/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.api.IPropagator;
import alexthw.ars_elemental.common.entity.spells.EntityCurvedProjectile;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.common.glyphs.MethodCurvedProjectile;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagatorArc
extends ElementalAbstractEffect
implements IPropagator {
    public static PropagatorArc INSTANCE = new PropagatorArc();

    public PropagatorArc() {
        super("propagator_arc", "Propagate Arc");
    }

    @Override
    public void propagate(Level world, Vec3 pos, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        ArrayList<EntityCurvedProjectile> projectiles = new ArrayList<EntityCurvedProjectile>();
        EntityCurvedProjectile projectileSpell = new EntityCurvedProjectile(world, resolver);
        projectileSpell.m_146884_(pos.m_82520_(0.0, 1.0, 0.0));
        projectiles.add(projectileSpell);
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        float sizeRatio = shooter.m_20192_() / 1.62f;
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.m_6350_().m_122427_();
            if (i % 2 == 0) {
                offset = offset.m_122424_();
            }
            BlockPos blockPos = new BlockPos(pos).m_5484_(offset, i).m_7637_(0.0, 1.5 * (double)sizeRatio, 0.0);
            EntityCurvedProjectile spell = new EntityCurvedProjectile(world, resolver);
            spell.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            projectiles.add(spell);
        }
        float velocity = MethodCurvedProjectile.getProjectileSpeed(stats);
        for (EntityProjectileSpell entityProjectileSpell : projectiles) {
            entityProjectileSpell.m_146884_(entityProjectileSpell.m_20182_().m_82520_(0.0, 0.25 * (double)sizeRatio, 0.0));
            entityProjectileSpell.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 0.3f);
            world.m_7967_((Entity)entityProjectileSpell);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 200;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return MethodCurvedProjectile.INSTANCE.getCompatibleAugments();
    }

    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }
}

