/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.entity.spells.EntityHomingProjectile;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractForm;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class MethodHomingProjectile
extends ElementalAbstractForm {
    public static MethodHomingProjectile INSTANCE = new MethodHomingProjectile();

    public MethodHomingProjectile() {
        super("homing_projectile", "Homing Projectile");
    }

    public void summonProjectiles(Level world, LivingEntity shooter, SpellStats stats, SpellResolver resolver, List<Predicate<LivingEntity>> ignore) {
        int numSplits = 1 + stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        ArrayList<EntityHomingProjectile> projectiles = new ArrayList<EntityHomingProjectile>();
        for (int i = 0; i < numSplits; ++i) {
            EntityHomingProjectile spell = new EntityHomingProjectile(world, resolver);
            projectiles.add(spell);
        }
        float velocity = MethodHomingProjectile.getProjectileSpeed(stats);
        int opposite = -1;
        int counter = 0;
        for (EntityHomingProjectile proj : projectiles) {
            proj.setIgnored(ignore);
            proj.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.8f);
            opposite *= -1;
            ++counter;
            world.m_7967_((Entity)proj);
        }
    }

    public static float getProjectileSpeed(SpellStats stats) {
        return Math.max(0.2f, 0.5f + stats.getAccMultiplier() / 5.0f);
    }

    public static void splits(Level world, LivingEntity shooter, BlockPos position, SpellResolver resolver, ArrayList<EntityHomingProjectile> projectiles, int numSplits) {
        float sizeRatio = shooter.m_20192_() / 1.62f;
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.m_6350_().m_122427_();
            if (i % 2 == 0) {
                offset = offset.m_122424_();
            }
            BlockPos projPos = position.m_5484_(offset, i / 2).m_7637_(0.0, 1.5 * (double)sizeRatio, 0.0);
            EntityHomingProjectile spell = new EntityHomingProjectile(world, resolver);
            spell.m_6034_(projPos.m_123341_(), projPos.m_123342_(), projPos.m_123343_());
            projectiles.add(spell);
        }
    }

    public CastResolveType onCast(ItemStack stack, LivingEntity shooter, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        ISummon summon;
        List<Predicate<LivingEntity>> ignore = MethodHomingProjectile.basicIgnores(shooter, spellStats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE), resolver.spell);
        if (shooter instanceof Player) {
            ignore.add(entity -> {
                if (!(entity instanceof ISummon)) return false;
                ISummon summon = (ISummon)entity;
                if (!shooter.m_20148_().equals(summon.getOwnerID())) return false;
                return true;
            });
            ignore.add(entity -> {
                OwnableEntity pet;
                return entity instanceof OwnableEntity && shooter.equals((Object)(pet = (OwnableEntity)entity).m_21826_());
            });
        } else if (shooter instanceof ISummon && (summon = (ISummon)shooter).getOwnerID() != null) {
            ignore.add(entity -> {
                if (!(entity instanceof ISummon)) return false;
                ISummon summon2 = (ISummon)entity;
                if (!summon.getOwnerID().equals(summon2.getOwnerID())) return false;
                return true;
            });
            ignore.add(entity -> {
                if (!(entity instanceof OwnableEntity)) return false;
                OwnableEntity pet = (OwnableEntity)entity;
                if (!summon.getOwnerID().equals(pet.m_21805_())) return false;
                return true;
            });
        }
        this.summonProjectiles(world, shooter, spellStats, resolver, ignore);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = context.m_43725_();
        Player shooter = context.m_43723_();
        this.onCast(null, (LivingEntity)shooter, world, spellStats, spellContext, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return CastResolveType.FAILURE;
    }

    public CastResolveType onCastOnEntity(ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.onCast(stack, caster, caster.f_19853_, spellStats, spellContext, resolver);
        return CastResolveType.SUCCESS;
    }

    public int getDefaultManaCost() {
        return 40;
    }

    public SpellTier getTier() {
        return SpellTier.THREE;
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> map) {
        map.put(AugmentPierce.INSTANCE.getRegistryName(), 1);
        return map;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentPierce.INSTANCE, AugmentSplit.INSTANCE, AugmentAccelerate.INSTANCE, AugmentDecelerate.INSTANCE, AugmentSensitive.INSTANCE});
    }

    public static List<Predicate<LivingEntity>> basicIgnores(LivingEntity shooter, Boolean targetPlayers, Spell spell) {
        Set<IFilter> filters;
        ArrayList<Predicate<LivingEntity>> ignore = new ArrayList<Predicate<LivingEntity>>();
        ignore.add(entity -> !entity.m_6084_());
        ignore.add(entity -> entity == shooter);
        ignore.add(entity -> entity instanceof FamiliarEntity);
        ignore.add(arg_0 -> ((LivingEntity)shooter).m_7307_(arg_0));
        if (!targetPlayers.booleanValue()) {
            ignore.add(entity -> entity instanceof Player);
        }
        if (!(filters = GlyphEffectUtil.getFilters(spell.recipe, 0)).isEmpty()) {
            ignore.add(entity -> GlyphEffectUtil.checkIgnoreFilters((Entity)entity, filters));
        }
        return ignore;
    }
}

