/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.entity.spells.EntityCurvedProjectile;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractForm;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class MethodCurvedProjectile
extends ElementalAbstractForm {
    public static MethodCurvedProjectile INSTANCE = new MethodCurvedProjectile();

    public static float getProjectileSpeed(SpellStats stats) {
        return Math.max(0.2f, 1.0f + stats.getAccMultiplier() / 2.0f);
    }

    public MethodCurvedProjectile() {
        super("curved_projectile", "Parable Projectile");
    }

    public void summonProjectiles(Level world, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        ArrayList<EntityCurvedProjectile> projectiles = new ArrayList<EntityCurvedProjectile>();
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        float sizeRatio = shooter.m_20192_() / 1.62f;
        for (int i = 1; i < 1 + numSplits + 1; ++i) {
            EntityCurvedProjectile spell = new EntityCurvedProjectile(world, resolver);
            projectiles.add(spell);
        }
        float velocity = MethodCurvedProjectile.getProjectileSpeed(stats);
        int opposite = -1;
        int counter = 0;
        for (EntityProjectileSpell entityProjectileSpell : projectiles) {
            entityProjectileSpell.m_146884_(entityProjectileSpell.m_20182_().m_82520_(0.0, 0.25 * (double)sizeRatio, 0.0));
            entityProjectileSpell.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.5f);
            opposite *= -1;
            ++counter;
            world.m_7967_((Entity)entityProjectileSpell);
        }
    }

    public CastResolveType onCast(ItemStack stack, LivingEntity shooter, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        this.summonProjectiles(world, shooter, spellStats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = context.m_43725_();
        Player shooter = context.m_43723_();
        this.summonProjectiles(world, (LivingEntity)shooter, spellStats, resolver);
        return CastResolveType.SUCCESS;
    }

    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        return CastResolveType.FAILURE;
    }

    public CastResolveType onCastOnEntity(ItemStack stack, LivingEntity caster, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.onCast(stack, caster, caster.f_19853_, spellStats, spellContext, resolver);
        return CastResolveType.SUCCESS;
    }

    public int getDefaultManaCost() {
        return 10;
    }

    public SpellTier getTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentPierce.INSTANCE, AugmentSplit.INSTANCE, AugmentAccelerate.INSTANCE, AugmentDecelerate.INSTANCE, AugmentSensitive.INSTANCE});
    }
}

