/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.summon;

import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.DolphinJumpGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummonDolphin
extends Dolphin
implements PlayerRideableJumping,
ISummon {
    public int ticksLeft;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(SummonDolphin.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public SummonDolphin(EntityType<? extends Dolphin> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SummonDolphin(Level world) {
        this((EntityType<? extends Dolphin>)((EntityType)ModEntities.DOLPHIN_SUMMON.get()), world);
    }

    public SummonDolphin(SummonHorse oldHorse, Player summoner) {
        this(summoner.f_19853_);
        BlockPos position = oldHorse.m_20183_();
        this.m_6034_(position.m_123341_(), position.m_123342_(), position.m_123343_());
        this.ticksLeft = oldHorse.getTicksLeft();
        this.setOwnerID(summoner.m_20148_());
        oldHorse.m_21220_().stream().filter(e -> e.m_19544_().m_19486_()).forEach(arg_0 -> ((SummonDolphin)this).m_7292_(arg_0));
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.DOLPHIN_SUMMON.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new DolphinJumpGoal((Dolphin)this, 10));
        this.f_21345_.m_25352_(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (passenger instanceof Mob) {
            Mob mob = (Mob)passenger;
            if (this.getControllingPassenger() == passenger) {
                this.f_20883_ = mob.f_20883_;
            }
        }
    }

    public double m_6048_() {
        return 0.45;
    }

    public boolean m_6146_() {
        return true;
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    protected boolean m_7341_(Entity pEntity) {
        return pEntity instanceof Player;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.f_19853_.m_5776_()) {
            return InteractionResult.PASS;
        }
        if (player.m_21205_().m_41619_() && !player.m_6144_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.m_20160_() && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float strafe = livingentity.f_20900_ * 0.5f;
                float forward = livingentity.f_20902_ * 2.0f;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.m_6109_()) {
                    if (this.m_28378_() > 2350) {
                        this.f_20887_ = 0.2f;
                    } else {
                        this.f_20887_ = 0.02f;
                        this.m_7910_((float)Math.min((double)this.m_6113_(), this.m_21133_(Attributes.f_22279_) + 0.5));
                    }
                    if (this.m_20069_()) {
                        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) + 2.5f);
                        float vert = (float)(pTravelVector.f_82480_ - 0.4 * (0.2 + (double)livingentity.m_146909_()));
                        super.m_7023_(new Vec3((double)strafe, (double)vert + 0.5, (double)forward));
                    } else {
                        super.m_7023_(new Vec3((double)strafe, pTravelVector.f_82480_, (double)forward));
                    }
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(pTravelVector);
            }
        }
    }

    protected float m_6108_() {
        return 0.97f;
    }

    protected void m_8024_() {
        LivingEntity livingEntity;
        if (this.m_20160_() && (livingEntity = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_20301_(player.m_6062_());
        }
    }

    public int m_213860_() {
        return 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.of(Util.f_137441_));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)this.m_20183_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.f_19853_, null, true);
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.onSummonDeath(this.f_19853_, cause, false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksLeft = compound.m_128451_("left");
        UUID uuid = null;
        if (compound.m_128403_("owner")) {
            uuid = compound.m_128342_("owner");
        }
        if (uuid != null) {
            this.setOwnerID(uuid);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("left", this.ticksLeft);
        this.writeOwner(compound);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Nullable
    public UUID getOwnerID() {
        return ((Optional)this.m_20088_().m_135370_(OWNER_UUID)).isEmpty() ? this.m_20148_() : (UUID)((Optional)this.m_20088_().m_135370_(OWNER_UUID)).get();
    }

    public void setOwnerID(UUID uuid) {
        this.m_20088_().m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void m_7888_(int pJumpPower) {
    }

    public boolean m_7132_() {
        return this.m_20069_() || this.m_28378_() > 2300;
    }

    public void m_7199_(int pJumpPower) {
        if (pJumpPower < 50) {
            return;
        }
        Direction direction = this.m_6374_();
        if (this.getControllingPassenger() != null && this.getControllingPassenger().m_146909_() > 20.0f) {
            this.m_20256_(this.m_20184_().m_82520_((double)direction.m_122429_(), -1.5, (double)direction.m_122431_()).m_82490_((double)(0.7f * (float)pJumpPower / 10.0f)));
        } else {
            this.m_20256_(this.m_20184_().m_82520_((double)direction.m_122429_(), 1.5, (double)direction.m_122431_()).m_82490_((double)(0.7f * (float)pJumpPower / 10.0f)));
        }
    }

    public void m_8012_() {
    }
}

