/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks;

import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import alexthw.ars_elemental.registry.ModTiles;
import alexthw.ars_elemental.util.BotaniaCompat;
import alexthw.ars_elemental.util.CompatUtils;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class EverfullUrnTile
extends ModdedTile
implements ITickable,
IWandable,
ITooltipProvider {
    Set<BlockPos> toList = new HashSet<BlockPos>();
    boolean needsSource;
    static final FluidStack waterStack = new FluidStack((Fluid)Fluids.f_76193_, 1000);

    public EverfullUrnTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.URN_TILE.get(), pWorldPosition, pBlockState);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.m_46467_() % 60L != 0L || this.toList.isEmpty() || this.f_58857_.f_46443_) {
            return;
        }
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        for (BlockPos toPos : this.toList) {
            if (this.needsSource) break;
            if (!this.f_58857_.m_46749_(toPos)) continue;
            if (!this.isRefillable(toPos, this.f_58857_)) {
                stale.add(toPos);
                continue;
            }
            if (!SourceUtil.hasSourceNearby((BlockPos)this.f_58858_, (Level)this.f_58857_, (int)6, (int)100) || !this.tryRefill(this.f_58857_, toPos)) continue;
            SourceUtil.takeSourceWithParticles((BlockPos)this.m_58899_(), (Level)this.f_58857_, (int)6, (int)100);
            this.createParticles(this.f_58858_.m_7494_(), toPos);
        }
        for (BlockPos s : stale) {
            this.toList.remove(s);
        }
        this.updateBlock();
    }

    private boolean tryRefill(Level world, BlockPos toPos) {
        IFluidHandler tank;
        if (world.m_8055_(toPos) == Blocks.f_50256_.m_49966_()) {
            world.m_46597_(toPos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
            return true;
        }
        BlockEntity be = world.m_7702_(toPos);
        if (be != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).isPresent() && be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).resolve().isPresent() && (tank = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).resolve().get()).fill(waterStack, IFluidHandler.FluidAction.SIMULATE) > 100) {
            tank.fill(waterStack, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return CompatUtils.isBotaniaLoaded() && BotaniaCompat.tryFillApothecary(toPos, world);
    }

    public void onWanded(Player playerEntity) {
        this.clearPos();
        PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.connections.cleared"));
    }

    public void clearPos() {
        this.toList.clear();
        this.updateBlock();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || !(this.f_58857_ instanceof ServerLevel) || storedPos.equals((Object)this.m_58899_())) {
            return;
        }
        if (this.isRefillable(storedPos, this.f_58857_)) {
            if (this.setSendTo(storedPos.m_7949_())) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237110_((String)"ars_nouveau.connections.send", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
                ParticleUtil.beam((BlockPos)storedPos, (BlockPos)this.f_58858_, (Level)this.f_58857_);
            } else {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.connections.fail"));
            }
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.connections.fail.urn"));
        }
    }

    private boolean isRefillable(BlockPos storedPos, Level level) {
        if (storedPos == null) {
            return false;
        }
        if (level.m_8055_(storedPos).m_60734_() instanceof AbstractCauldronBlock) {
            return true;
        }
        if (level.m_7702_(storedPos) != null && level.m_7702_(storedPos).getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).isPresent()) {
            return true;
        }
        return CompatUtils.isBotaniaLoaded() && BotaniaCompat.isApothecary(storedPos, level);
    }

    public void createParticles(BlockPos from, BlockPos to) {
        if (this.f_58857_ == null) {
            return;
        }
        EntityLerpedProjectile orb = new EntityLerpedProjectile(this.f_58857_, from, to, 20, 50, 255);
        this.f_58857_.m_7967_((Entity)orb);
    }

    public boolean setSendTo(BlockPos pos) {
        if (this.closeEnough(pos)) {
            this.toList.add(pos);
            this.updateBlock();
            return true;
        }
        return false;
    }

    public boolean closeEnough(BlockPos pos) {
        return BlockUtil.distanceFrom((BlockPos)pos, (BlockPos)this.f_58858_) <= this.getMaxDistance() && !pos.equals((Object)this.m_58899_());
    }

    private double getMaxDistance() {
        return 30.0;
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.toList == null || this.toList.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.relay.no_to"));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.relay.one_to", (Object[])new Object[]{this.toList.size()}));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.toList = new HashSet<BlockPos>();
        int counter = 0;
        while (NBTUtil.hasBlockPos((CompoundTag)tag, (String)("to_" + counter))) {
            BlockPos pos = NBTUtil.getNullablePos((CompoundTag)tag, (String)("to_" + counter));
            if (pos != null) {
                this.toList.add(pos);
            }
            ++counter;
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        int counter = 0;
        for (BlockPos p : this.toList) {
            NBTUtil.storeBlockPos((CompoundTag)tag, (String)("to_" + counter), (BlockPos)p);
            ++counter;
        }
    }
}

