/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.block;

import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.brdle.delightful.Util;
import net.brdle.delightful.common.block.ISliceable;
import net.brdle.delightful.common.config.DelightfulConfig;
import net.brdle.delightful.data.DelightfulItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class SlicedMiniMelonBlock
extends MelonBlock
implements ISliceable {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)1, (int)5);
    private final Supplier<Item> sliceItem;
    private final Supplier<Item> juiceItem;

    public SlicedMiniMelonBlock(BlockBehaviour.Properties pProperties, Supplier<Item> sliceItem, Supplier<Item> juiceItem) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(1)));
        this.sliceItem = sliceItem;
        this.juiceItem = juiceItem;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    @Override
    public ItemStack getSliceItem() {
        return this.sliceItem.get().m_7968_();
    }

    public ItemStack getJuiceItem() {
        return this.juiceItem.get().m_7968_();
    }

    @Override
    public int getMaxBites() {
        return 5;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_204117_(DelightfulItemTags.SCAVENGING_TOOLS)) {
            return this.cutSlice(level, pos, state, player, hand);
        }
        if (heldStack.m_150930_(Items.f_42590_) && this.juiceItem.get() != null && ((Boolean)DelightfulConfig.MELON_JUICING.get()).booleanValue()) {
            return this.bottleJuice(level, pos, state, player, hand);
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_()) {
            int bites;
            ItemStack sliceStack = this.getSliceItem();
            FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
            playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
            if (this.getSliceItem().m_41720_().m_41472_() && sliceFood != null) {
                for (Pair pair : sliceFood.m_38749_()) {
                    MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
                    if (effect == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    playerIn.m_7292_(new MobEffectInstance(effect));
                }
            }
            if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) == this.getMaxBites()) {
                level.m_7471_(pos, false);
            } else if (bites < this.getMaxBites()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            }
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        if (!level.m_5776_()) {
            int bites = (Integer)state.m_61143_((Property)BITES);
            if (bites == this.getMaxBites()) {
                level.m_7471_(pos, false);
            } else if (bites < this.getMaxBites()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            }
            Util.dropOrGive(this.getSliceItem(), level, pos, player);
            level.m_5594_(null, pos, SoundEvents.f_12634_, SoundSource.PLAYERS, 0.8f, 0.8f);
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(hand));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected InteractionResult bottleJuice(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        if (!level.m_5776_()) {
            int bites = (Integer)state.m_61143_((Property)BITES);
            int bites_left = this.getMaxBites() + 1 - bites;
            if (bites_left == 4) {
                level.m_7471_(pos, false);
            } else if (bites_left > 4) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 4)), 3);
            } else {
                return InteractionResult.FAIL;
            }
            player.m_21120_(hand).m_41774_(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getJuiceItem(), (int)0);
            level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.m_61143_((Property)BITES);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

