/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common;

import java.util.Objects;
import net.brdle.delightful.Util;
import net.brdle.delightful.common.block.DelightfulBlocks;
import net.brdle.delightful.common.block.SlicedMelonBlock;
import net.brdle.delightful.common.block.SlicedPumpkinBlock;
import net.brdle.delightful.common.config.DelightfulConfig;
import net.brdle.delightful.common.item.FurnaceFuelItem;
import net.brdle.delightful.common.item.knife.Knives;
import net.brdle.delightful.compat.Mods;
import net.brdle.delightful.data.DelightfulItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.block.PieBlock;

@Mod.EventBusSubscriber(modid="delightful")
public class ForgeEvents {
    @SubscribeEvent
    public static void burnTime(FurnaceFuelBurnTimeEvent e) {
        Item item = e.getItemStack().m_41720_();
        if (item instanceof FurnaceFuelItem) {
            FurnaceFuelItem fuel = (FurnaceFuelItem)item;
            e.setBurnTime(fuel.getFuelTime());
        }
    }

    @SubscribeEvent
    public static void fieryToolSetFire(LivingAttackEvent e) {
        LivingEntity living;
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof LivingEntity && ((living = (LivingEntity)entity).m_21205_().m_150930_((Item)Knives.FIERY.get()) || living.m_21205_().m_150930_((Item)Knives.KIWANO.get())) && !e.getEntity().m_5825_()) {
            e.getEntity().m_20254_(1);
        }
    }

    @SubscribeEvent
    public static void onKnightmetalToolDamage(LivingHurtEvent e) {
        LivingEntity living;
        ItemStack weapon;
        Entity entity;
        LivingEntity target = e.getEntity();
        if (!target.m_9236_().m_5776_() && (entity = e.getSource().m_7640_()) instanceof LivingEntity && !(weapon = (living = (LivingEntity)entity).m_21205_()).m_41619_() && target.m_21230_() > 0 && weapon.m_150930_((Item)Knives.KNIGHTMETAL.get())) {
            if (target.m_21207_() > 0.0f) {
                int moreBonus = (int)(2.0f * target.m_21207_());
                e.setAmount(e.getAmount() + (float)moreBonus);
            } else {
                e.setAmount(e.getAmount() + 2.0f);
            }
            ((ServerLevel)target.m_9236_()).m_7726_().m_8394_((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onInteract(PlayerInteractEvent.RightClickBlock e) {
        Level world = e.getLevel();
        BlockPos pos = e.getPos();
        if (e.getEntity().m_21120_(e.getHand()).m_204117_(DelightfulItemTags.SCAVENGING_TOOLS)) {
            BlockState current = world.m_8055_(pos);
            boolean client = world.m_5776_();
            if (current.m_60734_() == Blocks.f_50186_) {
                SlicedMelonBlock sliced = (SlicedMelonBlock)DelightfulBlocks.SLICED_MELON.get();
                ForgeEvents.slice(sliced.m_49966_(), sliced.getSliceItem(), world, pos, SoundEvents.f_11716_, e, client);
            } else if (current.m_60734_() == Blocks.f_50133_ && !e.getEntity().m_6047_()) {
                SlicedPumpkinBlock sliced = (SlicedPumpkinBlock)DelightfulBlocks.SLICED_PUMPKIN.get();
                ForgeEvents.slice(sliced.m_49966_(), sliced.getSliceItem(), world, pos, SoundEvents.f_11716_, e, client);
            } else if (Mods.loaded("frozenup", "frozen_delight") && Util.name(current.m_60734_()).equals("truffle_cake")) {
                int currentBites = (Integer)current.m_61143_((Property)BlockStateProperties.f_61412_);
                ItemStack slice = Objects.requireNonNull(Util.item("frozen_delight", "truffle_cake_slice")).m_7968_();
                if (currentBites >= 3) {
                    world.m_7471_(pos, false);
                    world.m_142346_((Entity)e.getEntity(), GameEvent.f_157794_, pos);
                    Util.dropOrGive(slice, world, pos, e.getEntity());
                    world.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.PLAYERS, 0.8f, 0.8f);
                    e.getEntity().m_21120_(e.getHand()).m_41622_(1, (LivingEntity)e.getEntity(), onBroken -> {});
                    e.setCancellationResult(InteractionResult.m_19078_((boolean)client));
                    e.setCanceled(true);
                    return;
                }
                ForgeEvents.slice((BlockState)current.m_61124_((Property)BlockStateProperties.f_61412_, (Comparable)Integer.valueOf(currentBites + 1)), slice, world, pos, SoundEvents.f_12642_, e, client);
            }
        }
    }

    public static void slice(BlockState block, ItemStack slice, Level world, BlockPos pos, SoundEvent sound, PlayerInteractEvent.RightClickBlock e, boolean client) {
        if (!client) {
            world.m_7731_(pos, block, 2);
            Util.dropOrGive(slice, world, pos, e.getEntity());
            world.m_5594_(null, pos, sound, SoundSource.PLAYERS, 0.8f, 0.8f);
            e.getEntity().m_21120_(e.getHand()).m_41622_(1, (LivingEntity)e.getEntity(), onBroken -> {});
        }
        e.setCancellationResult(InteractionResult.m_19078_((boolean)client));
        e.setCanceled(true);
    }

    @SubscribeEvent
    public static void onPieOverhaul(PlayerInteractEvent.RightClickBlock e) {
        ItemStack stack = e.getEntity().m_21120_(e.getHand());
        if (!stack.m_41619_()) {
            BlockPlaceContext context = new BlockPlaceContext(e.getEntity(), e.getHand(), stack, e.getHitVec());
            if (((Boolean)DelightfulConfig.PUMPKIN_PIE_OVERHAUL.get()).booleanValue() && stack.m_150930_(Items.f_42687_)) {
                ForgeEvents.tryPlacePie((PieBlock)DelightfulBlocks.PUMPKIN_PIE.get(), context, e);
            } else if (Mods.loaded("ars_nouveau") && DelightfulConfig.verify("source_berry_pie_slice") && ForgeEvents.isPie(stack, "ars_nouveau", "source_berry_pie")) {
                ForgeEvents.tryPlacePie((PieBlock)DelightfulBlocks.SOURCE_BERRY_PIE.get(), context, e);
            } else if (Mods.loaded("byg")) {
                if (DelightfulConfig.verify("blueberry_pie_slice") && ForgeEvents.isPie(stack, "byg", "blueberry_pie")) {
                    ForgeEvents.tryPlacePie((PieBlock)DelightfulBlocks.BLUEBERRY_PIE.get(), context, e);
                } else if (DelightfulConfig.verify("crimson_berry_pie_slice") && ForgeEvents.isPie(stack, "byg", "crimson_berry_pie")) {
                    ForgeEvents.tryPlacePie((PieBlock)DelightfulBlocks.CRIMSON_BERRY_PIE.get(), context, e);
                } else if (DelightfulConfig.verify("green_apple_pie_slice") && ForgeEvents.isPie(stack, "byg", "green_apple_pie")) {
                    ForgeEvents.tryPlacePie((PieBlock)DelightfulBlocks.GREEN_APPLE_PIE.get(), context, e);
                } else if (DelightfulConfig.verify("nightshade_berry_pie_slice") && ForgeEvents.isPie(stack, "byg", "nightshade_berry_pie")) {
                    ForgeEvents.tryPlacePie((PieBlock)DelightfulBlocks.NIGHTSHADE_BERRY_PIE.get(), context, e);
                }
            }
        }
    }

    public static void tryPlacePie(PieBlock pie, BlockPlaceContext context, PlayerInteractEvent.RightClickBlock e) {
        e.setUseItem(Event.Result.DENY);
        e.setCanceled(true);
        if (e.getUseBlock() != Event.Result.ALLOW) {
            if (ForgeEvents.placePie(pie, context)) {
                e.setCancellationResult(InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()));
            }
        } else {
            e.setUseBlock(Event.Result.ALLOW);
        }
    }

    public static boolean placePie(PieBlock pie, BlockPlaceContext context) {
        if (context.m_7059_() && context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60767_().m_76333_()) {
            BlockState piestate = pie.m_5573_(context);
            if (!context.m_43723_().m_150110_().f_35937_) {
                context.m_43722_().m_41774_(1);
            }
            context.m_43725_().m_7731_(context.m_8083_(), piestate, 2);
            piestate.m_60734_().m_6402_(context.m_43725_(), context.m_8083_(), piestate, (LivingEntity)context.m_43723_(), context.m_43722_());
            context.m_43725_().m_220407_(GameEvent.f_157797_, context.m_8083_(), GameEvent.Context.m_223719_((Entity)context.m_43723_(), (BlockState)piestate));
            context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_12642_, SoundSource.PLAYERS, 0.8f, 0.8f);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPieOverhaul(PlayerInteractEvent.RightClickItem e) {
        ItemStack stack = e.getEntity().m_21120_(e.getHand());
        if ((Boolean)DelightfulConfig.PUMPKIN_PIE_OVERHAUL.get() != false && stack.m_150930_(Items.f_42687_) || Mods.loaded("ars_nouveau") && stack.m_150930_(Util.item("ars_nouveau", "source_berry_pie")) && DelightfulConfig.verify("source_berry_pie_slice") || Mods.loaded("byg") && (ForgeEvents.isPie(e.getItemStack(), "byg", "blueberry_pie") && DelightfulConfig.verify("blueberry_pie_slice") || ForgeEvents.isPie(e.getItemStack(), "byg", "crimson_berry_pie") && DelightfulConfig.verify("crimson_berry_pie_slice") || ForgeEvents.isPie(e.getItemStack(), "byg", "green_apple_pie") && DelightfulConfig.verify("green_apple_pie_slice") || ForgeEvents.isPie(e.getItemStack(), "byg", "nightshade_berry_pie") && DelightfulConfig.verify("nightshade_berry_pie_slice"))) {
            e.setCancellationResult(InteractionResult.FAIL);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPieTooltip(ItemTooltipEvent e) {
        BlockItem block;
        Item item;
        if (e.getItemStack().m_150930_(Items.f_42687_) && (Boolean)DelightfulConfig.PUMPKIN_PIE_OVERHAUL.get() != false || (item = e.getItemStack().m_41720_()) instanceof BlockItem && (block = (BlockItem)item).m_40614_() instanceof PieBlock || Mods.loaded("ars_nouveau") && ForgeEvents.isPie(e.getItemStack(), "ars_nouveau", "source_berry_pie") && DelightfulConfig.verify("source_berry_pie_slice") || Mods.loaded("ars_nouveau") && (ForgeEvents.isPie(e.getItemStack(), "byg", "blueberry_pie") && DelightfulConfig.verify("blueberry_pie_slice") || ForgeEvents.isPie(e.getItemStack(), "byg", "crimson_berry_pie") && DelightfulConfig.verify("crimson_berry_pie_slice") || ForgeEvents.isPie(e.getItemStack(), "byg", "green_apple_pie") && DelightfulConfig.verify("green_apple_pie_slice") || ForgeEvents.isPie(e.getItemStack(), "byg", "nightshade_berry_pie") && DelightfulConfig.verify("nightshade_berry_pie_slice")) || Mods.loaded("wildberries") && (e.getItemStack().m_204117_(Util.it("wildberries", "berry_pies")) || e.getItemStack().m_204117_(Util.it("wildberries", "berry_muffins")))) {
            e.getToolTip().add(Component.m_237115_((String)"delightful.placeable.desc").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    private static boolean isPie(ItemStack stack, String modid, String pie) {
        return stack.m_150930_(Util.item(modid, pie));
    }
}

