/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.block.rail.MultiShapeRail;
import dev.murad.shipping.entity.custom.train.AbstractTrainCarEntity;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RailHelper {
    private final AbstractMinecart minecart;
    public static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), map -> {
        Vec3i west = Direction.WEST.m_122436_();
        Vec3i east = Direction.EAST.m_122436_();
        Vec3i north = Direction.NORTH.m_122436_();
        Vec3i south = Direction.SOUTH.m_122436_();
        Vec3i westb = west.m_7495_();
        Vec3i eastb = east.m_7495_();
        Vec3i nothb = north.m_7495_();
        Vec3i southb = south.m_7495_();
        map.put(RailShape.NORTH_SOUTH, Pair.of((Object)north, (Object)south));
        map.put(RailShape.EAST_WEST, Pair.of((Object)west, (Object)east));
        map.put(RailShape.ASCENDING_EAST, Pair.of((Object)westb, (Object)east));
        map.put(RailShape.ASCENDING_WEST, Pair.of((Object)west, (Object)eastb));
        map.put(RailShape.ASCENDING_NORTH, Pair.of((Object)north, (Object)southb));
        map.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)nothb, (Object)south));
        map.put(RailShape.SOUTH_EAST, Pair.of((Object)south, (Object)east));
        map.put(RailShape.SOUTH_WEST, Pair.of((Object)south, (Object)west));
        map.put(RailShape.NORTH_WEST, Pair.of((Object)north, (Object)west));
        map.put(RailShape.NORTH_EAST, Pair.of((Object)north, (Object)east));
    });
    private static final int MAX_VISITED = 200;
    public static final Map<RailShape, Pair<RailDir, RailDir>> EXITS_DIRECTION = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), map -> {
        map.put(RailShape.NORTH_SOUTH, Pair.of((Object)new RailDir(Direction.NORTH), (Object)new RailDir(Direction.SOUTH)));
        map.put(RailShape.EAST_WEST, Pair.of((Object)new RailDir(Direction.WEST), (Object)new RailDir(Direction.EAST)));
        map.put(RailShape.ASCENDING_EAST, Pair.of((Object)new RailDir(Direction.WEST), (Object)new RailDir(Direction.EAST, true)));
        map.put(RailShape.ASCENDING_WEST, Pair.of((Object)new RailDir(Direction.WEST, true), (Object)new RailDir(Direction.EAST)));
        map.put(RailShape.ASCENDING_NORTH, Pair.of((Object)new RailDir(Direction.NORTH, true), (Object)new RailDir(Direction.SOUTH)));
        map.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)new RailDir(Direction.NORTH), (Object)new RailDir(Direction.SOUTH, true)));
        map.put(RailShape.SOUTH_EAST, Pair.of((Object)new RailDir(Direction.SOUTH), (Object)new RailDir(Direction.EAST)));
        map.put(RailShape.SOUTH_WEST, Pair.of((Object)new RailDir(Direction.WEST), (Object)new RailDir(Direction.SOUTH)));
        map.put(RailShape.NORTH_WEST, Pair.of((Object)new RailDir(Direction.WEST), (Object)new RailDir(Direction.NORTH)));
        map.put(RailShape.NORTH_EAST, Pair.of((Object)new RailDir(Direction.NORTH), (Object)new RailDir(Direction.EAST)));
    });

    public RailHelper(AbstractMinecart minecart) {
        this.minecart = minecart;
    }

    @NotNull
    public RailShape getShape(BlockPos pos) {
        BlockState state = this.minecart.f_19853_.m_8055_(pos);
        return ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)this.minecart.f_19853_, pos, this.minecart);
    }

    @NotNull
    public static RailShape getShape(BlockPos pos, Level level) {
        BlockState state = level.m_8055_(pos);
        return ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)level, pos, null);
    }

    @NotNull
    public RailShape getShape(BlockPos pos, Direction direction) {
        BlockState state = this.minecart.f_19853_.m_8055_(pos);
        if (state.m_60734_() instanceof MultiShapeRail) {
            return ((MultiShapeRail)state.m_60734_()).getVanillaRailShapeFromDirection(state, pos, this.minecart.f_19853_, direction);
        }
        return ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)this.minecart.f_19853_, pos, this.minecart);
    }

    public static Optional<BlockPos> getRail(BlockPos inpos, Level level) {
        for (BlockPos pos : Arrays.asList(inpos, inpos.m_7495_())) {
            BlockState state = level.m_8055_(pos);
            if (!(state.m_60734_() instanceof BaseRailBlock)) continue;
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public static Direction directionFromVelocity(Vec3 deltaMovement) {
        if (Math.abs(deltaMovement.f_82479_) > Math.abs(deltaMovement.f_82481_)) {
            return deltaMovement.f_82479_ > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return deltaMovement.f_82481_ > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public Optional<Pair<Direction, Integer>> traverseBi(BlockPos railPos, BiPredicate<Direction, BlockPos> predicate, int limit, AbstractTrainCarEntity car) {
        return RailHelper.getRail(railPos, this.minecart.f_19853_).flatMap(pos -> {
            RailShape shape = this.getShape((BlockPos)pos, car.m_6350_().m_122424_());
            Pair<RailDir, RailDir> dirs = EXITS_DIRECTION.get(shape);
            Optional<Integer> first = this.traverse((BlockPos)pos, this.minecart.f_19853_, ((RailDir)dirs.getSecond()).horizontal.m_122424_(), predicate, limit);
            Optional<Integer> second = this.traverse((BlockPos)pos, this.minecart.f_19853_, ((RailDir)dirs.getFirst()).horizontal.m_122424_(), predicate, limit);
            if (second.isEmpty()) {
                return first.map(i -> Pair.of((Object)((RailDir)dirs.getFirst()).horizontal, (Object)i));
            }
            if (first.isEmpty()) {
                return second.map(i -> Pair.of((Object)((RailDir)dirs.getSecond()).horizontal, (Object)i));
            }
            return Optional.of(first.get() < second.get() ? Pair.of((Object)((RailDir)dirs.getFirst()).horizontal, (Object)first.get()) : Pair.of((Object)((RailDir)dirs.getSecond()).horizontal, (Object)second.get()));
        });
    }

    public static Optional<RailDir> getOtherExit(Direction direction, RailShape shape) {
        Pair<RailDir, RailDir> dirs = EXITS_DIRECTION.get(shape);
        if (((RailDir)dirs.getFirst()).horizontal.equals((Object)direction)) {
            return Optional.of((RailDir)dirs.getSecond());
        }
        if (((RailDir)dirs.getSecond()).horizontal.equals((Object)direction)) {
            return Optional.of((RailDir)dirs.getFirst());
        }
        return Optional.empty();
    }

    public static Optional<Vec3i> getDirectionToOtherExit(Direction direction, RailShape shape) {
        return RailHelper.getOtherExit(direction, shape).map(other -> direction.m_122436_().m_121996_(other.horizontal.m_122436_()));
    }

    public Optional<Integer> traverse(BlockPos railPos, Level level, Direction prevExitTaken, BiPredicate<Direction, BlockPos> predicate, int limit) {
        if (predicate.test(prevExitTaken, railPos)) {
            return Optional.of(0);
        }
        if (limit < 1) {
            return Optional.empty();
        }
        Direction entrance = prevExitTaken.m_122424_();
        return RailHelper.getRail(railPos, level).flatMap(pos -> {
            RailShape shape = this.getShape((BlockPos)pos, prevExitTaken);
            return RailHelper.getOtherExit(entrance, shape).flatMap(raildir -> this.traverse(raildir.above ? pos.m_121945_(raildir.horizontal).m_7494_() : pos.m_121945_(raildir.horizontal), level, raildir.horizontal, predicate, limit - 1).map(ans -> ans + 1));
        });
    }

    public Optional<Pair<BlockPos, Direction>> getNext(BlockPos railpos, Direction direction) {
        RailShape shape = this.getShape(railpos, direction);
        Direction entrance = direction.m_122424_();
        return RailHelper.getOtherExit(entrance, shape).flatMap(raildir -> RailHelper.getRail(raildir.above ? railpos.m_121945_(raildir.horizontal).m_7494_() : railpos.m_121945_(raildir.horizontal), this.minecart.f_19853_).map(pos -> Pair.of((Object)pos, (Object)raildir.horizontal)));
    }

    private List<RailDir> getNextNodes(BlockPos pos, Direction prevExitTaken) {
        Direction inputSide = prevExitTaken.m_122424_();
        BlockState state = this.minecart.f_19853_.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof MultiShapeRail) {
            MultiShapeRail r = (MultiShapeRail)block;
            return r.getPossibleOutputDirections(state, inputSide).stream().map(RailDir::new).collect(Collectors.toList());
        }
        RailShape shape = this.getShape(pos, prevExitTaken);
        List<RailShape> shapes = List.of(shape);
        return shapes.stream().map(shape1 -> {
            Pair<RailDir, RailDir> dirs = EXITS_DIRECTION.get(shape);
            if (((RailDir)dirs.getFirst()).horizontal.equals((Object)inputSide)) {
                return (RailDir)dirs.getSecond();
            }
            if (((RailDir)dirs.getSecond()).horizontal.equals((Object)inputSide)) {
                return (RailDir)dirs.getFirst();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Optional<RailPathFindNode> pathfind(BlockPos railPos, Direction prevDirTaken, Function<BlockPos, Double> heuristic) {
        HashSet<Pair> visited = new HashSet<Pair>();
        PriorityQueue<RailPathFindNode> queue = new PriorityQueue<RailPathFindNode>();
        PriorityQueue ends = new PriorityQueue();
        queue.add(new RailPathFindNode(railPos, prevDirTaken, 0, heuristic.apply(railPos)));
        while (!queue.isEmpty() && visited.size() < 200 && ((RailPathFindNode)queue.peek()).heuristicValue > 0.0) {
            RailPathFindNode curr = (RailPathFindNode)queue.poll();
            if (visited.contains(Pair.of((Object)curr.pos, (Object)curr.prevExitTaken))) continue;
            visited.add(Pair.of((Object)curr.pos, (Object)curr.prevExitTaken));
            this.getNextNodes(curr.pos, curr.prevExitTaken).forEach(raildir -> {
                BlockPos pos;
                BlockPos blockPos = pos = raildir.above ? curr.pos.m_121945_(raildir.horizontal).m_7494_() : curr.pos.m_121945_(raildir.horizontal);
                if (this.minecart.f_19853_.m_8055_(pos).m_60713_(Blocks.f_50626_)) {
                    ends.add(new RailPathFindNode(pos, raildir.horizontal, curr.pathLength + 1, (Double)heuristic.apply(pos)));
                } else {
                    RailHelper.getRail(pos, this.minecart.f_19853_).ifPresent(nextPos -> queue.add(new RailPathFindNode((BlockPos)nextPos, raildir.horizontal, curr.pathLength + 1, (Double)heuristic.apply((BlockPos)nextPos))));
                }
            });
        }
        queue.addAll(ends);
        return queue.isEmpty() ? Optional.empty() : Optional.of((RailPathFindNode)queue.peek());
    }

    public static BiPredicate<Direction, BlockPos> samePositionPredicate(AbstractTrainCarEntity entity) {
        Optional<BlockPos> targetRail = RailHelper.getRail(entity.m_20097_().m_7494_(), entity.f_19853_);
        return (direction, p) -> RailHelper.getRail(p, entity.f_19853_).flatMap(pos -> targetRail.map(rp -> rp.equals(pos))).orElse(false);
    }

    public Direction pickCheaperDir(List<Direction> directions, BlockPos pos, Function<BlockPos, Double> heuristic, Level level) {
        List hasOutputDirections = directions.stream().map(d -> new Pair(d, RailHelper.getRail(pos.m_121945_(d), level))).filter(p -> ((Optional)p.getSecond()).isPresent()).map(p -> new Pair((Object)((Direction)p.getFirst()), (Object)((BlockPos)((Optional)p.getSecond()).get()))).collect(Collectors.toList());
        if (hasOutputDirections.isEmpty()) {
            return directions.get(0);
        }
        List hasPath = hasOutputDirections.stream().map(p -> new Pair((Object)((Direction)p.getFirst()), this.pathfind((BlockPos)p.getSecond(), (Direction)p.getFirst(), heuristic))).filter(p -> ((Optional)p.getSecond()).isPresent()).map(p -> new Pair((Object)((Direction)p.getFirst()), (Object)((RailPathFindNode)((Optional)p.getSecond()).get()))).collect(Collectors.toList());
        if (hasPath.isEmpty()) {
            return (Direction)((Pair)hasOutputDirections.get(0)).getFirst();
        }
        Pair best = hasPath.stream().min(Comparator.comparing(Pair::getSecond)).get();
        return (Direction)best.getFirst();
    }

    public static Function<BlockPos, Double> samePositionHeuristic(BlockPos p) {
        return arg_0 -> ((BlockPos)p).m_123331_(arg_0);
    }

    public static Function<BlockPos, Double> samePositionHeuristicSet(Set<BlockPos> potentialDestinations) {
        return pos -> potentialDestinations.stream().map(p -> p.m_123331_((Vec3i)pos)).min(Double::compareTo).orElse(0.0);
    }

    public static Vec3 toVec3(Vec3i dir) {
        return new Vec3((double)dir.m_123341_(), (double)dir.m_123342_(), (double)dir.m_123343_());
    }

    public static class RailDir {
        public Direction horizontal;
        public boolean above;

        RailDir(Direction h, boolean v) {
            this.horizontal = h;
            this.above = v;
        }

        RailDir(Direction h) {
            this.horizontal = h;
            this.above = false;
        }
    }

    private static class RailPathFindNode
    implements Comparable<RailPathFindNode> {
        BlockPos pos;
        Direction prevExitTaken;
        int pathLength;
        double heuristicValue;

        RailPathFindNode(BlockPos pos, Direction prevExitTaken, int pathLength, double heuristicValue) {
            this.pos = pos;
            this.prevExitTaken = prevExitTaken;
            this.pathLength = pathLength;
            this.heuristicValue = heuristicValue;
        }

        @Override
        public int compareTo(@NotNull RailPathFindNode o) {
            if (this.heuristicValue == o.heuristicValue) {
                return this.pathLength - o.pathLength;
            }
            return this.heuristicValue - o.heuristicValue < 0.0 ? -1 : 1;
        }
    }
}

