/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.rail;

import dev.murad.shipping.block.rail.MultiShapeRail;
import dev.murad.shipping.util.RailHelper;
import dev.murad.shipping.util.RailShapeUtil;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class JunctionRail
extends BaseRailBlock
implements MultiShapeRail {
    private static final Logger log = LogManager.getLogger(JunctionRail.class);
    public static final EnumProperty<RailShape> RAIL_SHAPE = RailShapeUtil.RAIL_SHAPE_STRAIGHT_FLAT;
    static final Set<Direction> NO_POSSIBILITIES = Set.of();

    public JunctionRail(BlockBehaviour.Properties pProperties) {
        super(true, pProperties);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockstate = super.m_49966_();
        return (BlockState)((BlockState)blockstate.m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(flag))).m_61124_(RAIL_SHAPE, (Comparable)RailShapeUtil.DEFAULT);
    }

    protected BlockState m_49389_(BlockState pState, Level pLevel, BlockPos pPos, boolean pIsMoving) {
        return pState;
    }

    @Deprecated
    public Property<RailShape> m_7978_() {
        return RAIL_SHAPE;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return f_49355_;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public RailShape getRailDirection(BlockState state, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        if (cart == null) {
            return (RailShape)state.m_61143_(this.m_7978_());
        }
        return RailHelper.directionFromVelocity(cart.m_20184_()).m_122434_() == Direction.Axis.X ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return pState;
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{f_152149_, RAIL_SHAPE});
    }

    @Override
    public boolean setRailState(BlockState state, Level world, BlockPos pos, Direction in, Direction out) {
        return in.m_122434_().m_122479_() && in.m_122424_() == out;
    }

    @Override
    public Set<Direction> getPossibleOutputDirections(BlockState state, Direction inputSide) {
        if (inputSide.m_122434_().m_122479_()) {
            return Set.of(inputSide.m_122424_());
        }
        return NO_POSSIBILITIES;
    }

    @Override
    public Set<Direction> getPriorityDirectionsToCheck(BlockState state, Direction entrance) {
        if (entrance.equals((Object)Direction.EAST) || entrance.equals((Object)Direction.WEST)) {
            return Set.of(Direction.NORTH, Direction.SOUTH);
        }
        return Set.of();
    }

    @Override
    public RailShape getVanillaRailShapeFromDirection(BlockState state, BlockPos pos, Level level, Direction direction) {
        if (direction.equals((Object)Direction.EAST) || direction.equals((Object)Direction.WEST)) {
            return RailShape.EAST_WEST;
        }
        return RailShape.NORTH_SOUTH;
    }

    @Override
    public boolean isAutomaticSwitching() {
        return false;
    }
}

