/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;

public class SinkTileEntity
extends TileEntity {
    private final FluidTank fluidHandler = new WaterTank(16000);
    private final SinkItemProvider itemProvider = new SinkItemProvider(this.fluidHandler);
    private final LazyOptional<IFluidHandler> fluidHandlerCap = LazyOptional.of(() -> this.fluidHandler);
    private final LazyOptional<IKitchenItemProvider> itemProviderCap = LazyOptional.of(() -> this.itemProvider);
    private DyeColor color = DyeColor.WHITE;

    public SinkTileEntity() {
        super(ModTileEntities.sink);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.fluidHandler.writeToNBT(tagCompound);
        tagCompound.func_74774_a("Color", (byte)this.color.func_196059_a());
        return tagCompound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.fluidHandler.readFromNBT(tagCompound);
        this.color = DyeColor.func_196056_a((int)tagCompound.func_74771_c("Color"));
    }

    public int getWaterAmount() {
        return this.fluidHandler.getFluidAmount();
    }

    public int getWaterCapacity() {
        return this.fluidHandler.getCapacity();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional result = CapabilityKitchenItemProvider.CAPABILITY.orEmpty(capability, this.itemProviderCap);
        if (!result.isPresent()) {
            result = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(capability, this.fluidHandlerCap);
        }
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(capability, facing);
    }

    private static class SinkItemProvider
    extends DefaultKitchenItemProvider {
        private final NonNullList<ItemStack> itemStacks = NonNullList.func_191196_a();
        private final FluidTank fluidTank;
        private int waterUsed;

        public SinkItemProvider(FluidTank fluidTank) {
            this.fluidTank = fluidTank;
            this.itemStacks.addAll(CookingRegistry.getWaterItems());
        }

        @Override
        public void resetSimulation() {
            this.waterUsed = 0;
        }

        @Override
        public int getSimulatedUseCount(int slot) {
            return this.waterUsed / 1000;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (!((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue() || this.fluidTank.getFluidAmount() - this.waterUsed > amount * 1000) {
                if (requireBucket && ((ItemStack)this.itemStacks.get(slot)).func_77973_b() == Items.field_151117_aB && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return ItemStack.field_190927_a;
                }
                if (simulate) {
                    this.waterUsed += amount * 1000;
                } else {
                    this.fluidTank.drain(amount * 1000, IFluidHandler.FluidAction.EXECUTE);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.itemStacks.get(slot)), (int)amount);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemStack, (ItemStack)providedStack)) continue;
                this.fluidTank.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                break;
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue() && this.fluidTank.getFluidAmount() - this.waterUsed < 1000) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)this.itemStacks.get(slot);
        }
    }

    private static class WaterTank
    extends FluidTank {
        private static final FluidStack MAX_WATER = new FluidStack((Fluid)Fluids.field_204546_a, Integer.MAX_VALUE);

        public WaterTank(int capacity) {
            super(capacity);
        }

        public FluidStack getFluid() {
            if (!((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue()) {
                return MAX_WATER;
            }
            return super.getFluid();
        }

        public int getFluidAmount() {
            if (!((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue()) {
                return Integer.MAX_VALUE;
            }
            return super.getFluidAmount();
        }

        public int getCapacity() {
            if (!((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue()) {
                return Integer.MAX_VALUE;
            }
            return super.getCapacity();
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue() && resource.getFluid() == Fluids.field_204546_a) {
                return resource.copy();
            }
            return super.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!((Boolean)CookingForBlockheadsConfig.COMMON.sinkRequiresWater.get()).booleanValue()) {
                return new FluidStack((Fluid)Fluids.field_204546_a, maxDrain);
            }
            return super.drain(maxDrain, action);
        }
    }
}

