/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.container.FridgeContainer;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class FridgeTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            FridgeTileEntity.this.isDirty = true;
            FridgeTileEntity.this.func_70296_d();
        }
    };
    private final KitchenItemProvider itemProvider = new KitchenItemProvider((IItemHandler)this.itemHandler){
        private final ItemStack snowStack;
        private final ItemStack iceStack;
        {
            this.snowStack = new ItemStack((IItemProvider)Items.field_151126_ay);
            this.iceStack = new ItemStack((IItemProvider)Blocks.field_150432_aD);
        }

        @Nullable
        private SourceItem applyIceUnit(IngredientPredicate predicate, int maxAmount) {
            if (FridgeTileEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.snowStack, 64)) {
                return new SourceItem(this, -1, ItemHandlerHelper.copyStackWithSize((ItemStack)this.snowStack, (int)maxAmount));
            }
            if (FridgeTileEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.iceStack, 64)) {
                return new SourceItem(this, -1, ItemHandlerHelper.copyStackWithSize((ItemStack)this.iceStack, (int)maxAmount));
            }
            return null;
        }

        @Override
        @Nullable
        public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeTileEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = (it, count) -> (count > 1 || !it.func_77973_b().getContainerItem(it).func_190926_b() || CookingRegistry.isToolItem(it)) && predicate.test(it, count);
            }
            return super.findSource(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }

        @Override
        @Nullable
        public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeTileEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = (it, count) -> (count > 1 || !it.func_77973_b().getContainerItem(it).func_190926_b() || CookingRegistry.isToolItem(it)) && predicate.test(it, count);
            }
            return super.findSourceAndMarkAsUsed(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 1, 2);
    private final LazyOptional<IKitchenItemProvider> itemProviderCap = LazyOptional.of(() -> this.itemProvider);
    private boolean isDirty;
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;

    public FridgeTileEntity() {
        super(ModTileEntities.fridge);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen(ModSounds.fridgeOpen);
        this.doorAnimator.setSoundEventClose(ModSounds.fridgeClose);
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.markDirtyAndUpdate();
    }

    public void func_73660_a() {
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.hasIceUpgrade = tagCompound.func_74767_n("HasIceUpgrade");
        this.hasPreservationUpgrade = tagCompound.func_74767_n("HasPreservationUpgrade");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        tagCompound.func_74757_a("HasIceUpgrade", this.hasIceUpgrade);
        tagCompound.func_74757_a("HasPreservationUpgrade", this.hasPreservationUpgrade);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tagCompound = new CompoundNBT();
        this.func_189515_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return tagCompound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nullable
    public FridgeTileEntity findNeighbourFridge() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() instanceof FridgeBlock) {
            return (FridgeTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() instanceof FridgeBlock) {
            return (FridgeTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        }
        return null;
    }

    public FridgeTileEntity getBaseFridge() {
        FridgeTileEntity baseFridge;
        if (!this.func_145830_o()) {
            return this;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() instanceof FridgeBlock && (baseFridge = (FridgeTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null) {
            return baseFridge;
        }
        return this;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional result = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.getCombinedItemHandlerCapability());
        if (!result.isPresent()) {
            result = CapabilityKitchenItemProvider.CAPABILITY.orEmpty(capability, this.itemProviderCap);
        }
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(capability, facing);
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public LazyOptional<IItemHandler> getCombinedItemHandlerCapability() {
        return LazyOptional.of(this::getCombinedItemHandler);
    }

    public IItemHandler getCombinedItemHandler() {
        FridgeTileEntity baseFridge = this.getBaseFridge();
        FridgeTileEntity neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{neighbourFridge.itemHandler, baseFridge.itemHandler});
        }
        return this.itemHandler;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public void markDirtyAndUpdate() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3, 512);
        this.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.cookingforblockheads.fridge");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FridgeContainer(i, playerInventory, this);
    }
}

