/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.api.SinkHandler;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.compat.HarvestCraftAddon;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.GeneralFoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.SmeltingFood;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CookingRegistry {
    private static final List<IRecipe<IInventory>> recipeList = Lists.newArrayList();
    private static final ArrayListMultimap<ResourceLocation, FoodRecipe> foodItems = ArrayListMultimap.create();
    private static final NonNullList<ItemStack> tools = NonNullList.func_191196_a();
    private static final Map<ItemStack, Integer> ovenFuelItems = Maps.newHashMap();
    private static final Map<ItemStack, ItemStack> ovenRecipes = Maps.newHashMap();
    private static final Map<ItemStack, SinkHandler> sinkHandlers = Maps.newHashMap();
    private static final Map<ItemStack, ToasterHandler> toastHandlers = Maps.newHashMap();
    private static final NonNullList<ItemStack> waterItems = NonNullList.func_191196_a();
    private static final NonNullList<ItemStack> milkItems = NonNullList.func_191196_a();
    private static final List<ISortButton> customSortButtons = Lists.newArrayList();
    private static Collection<ItemStack> nonFoodRecipes = Collections.emptyList();

    public static void initFoodRegistry(RecipeManager recipeManager) {
        recipeList.clear();
        foodItems.clear();
        FoodRegistryInitEvent init = new FoodRegistryInitEvent();
        MinecraftForge.EVENT_BUS.post((Event)init);
        nonFoodRecipes = init.getNonFoodRecipes();
        block0: for (IRecipe recipe : recipeManager.func_199510_b()) {
            ItemStack output;
            if (recipe.func_222127_g() == IRecipeType.field_222152_d || recipe.func_222127_g() == IRecipeType.field_222153_e || (output = recipe.func_77571_b()).func_190926_b()) continue;
            if (output.func_77973_b().func_219971_r()) {
                if (HarvestCraftAddon.isWeirdConversionRecipe(recipe)) continue;
                CookingRegistry.addFoodRecipe((IRecipe<? extends IInventory>)recipe);
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!recipe.func_77571_b().func_77969_a(itemStack)) continue;
                CookingRegistry.addFoodRecipe((IRecipe<? extends IInventory>)recipe);
                continue block0;
            }
        }
    }

    public static boolean isNonFoodRecipe(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (ItemStack nonFoodStack : nonFoodRecipes) {
            if (!itemStack.func_77969_a(nonFoodStack)) continue;
            return true;
        }
        return false;
    }

    public static void addFoodRecipe(IRecipe<? extends IInventory> recipe) {
        ItemStack output = recipe.func_77571_b();
        if (!output.func_190926_b() && !recipe.func_192400_c().isEmpty()) {
            FoodRecipe foodRecipe;
            if (recipe instanceof AbstractCookingRecipe) {
                foodRecipe = new SmeltingFood(recipe);
            } else if (recipe instanceof ShapedRecipe || recipe instanceof ShapelessRecipe) {
                foodRecipe = new GeneralFoodRecipe(recipe);
            } else {
                return;
            }
            recipeList.add(recipe);
            foodItems.put((Object)output.func_77973_b().getRegistryName(), (Object)foodRecipe);
        }
    }

    public static Multimap<ResourceLocation, FoodRecipe> getFoodRecipes() {
        return foodItems;
    }

    public static Collection<FoodRecipe> getFoodRecipes(ItemStack outputItem) {
        return foodItems.get((Object)outputItem.func_77973_b().getRegistryName());
    }

    public static Collection<FoodRecipe> getFoodRecipes(ResourceLocation outputItem) {
        return foodItems.get((Object)outputItem);
    }

    public static void addToolItem(ItemStack toolItem) {
        tools.add((Object)toolItem);
    }

    public static boolean isToolItem(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        for (ItemStack toolItem : tools) {
            if (!toolItem.func_185136_b(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolItem(Ingredient ingredient) {
        for (ItemStack itemStack : ingredient.func_193365_a()) {
            if (!CookingRegistry.isToolItem(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void addOvenFuel(ItemStack itemStack, int fuelTime) {
        ovenFuelItems.put(itemStack, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!entry.getKey().func_77969_a(itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static void addSmeltingItem(ItemStack source, ItemStack result) {
        ovenRecipes.put(source, result);
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : ovenRecipes.entrySet()) {
            if (!entry.getKey().func_77969_a(itemStack)) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    public static void addToasterHandler(ItemStack itemStack, ToasterHandler toastHandler) {
        toastHandlers.put(itemStack, toastHandler);
    }

    @Nullable
    public static ToasterHandler getToasterHandler(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ToasterHandler> entry : toastHandlers.entrySet()) {
            if (!entry.getKey().func_77969_a(itemStack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addSinkHandler(ItemStack itemStack, SinkHandler sinkHandler) {
        sinkHandlers.put(itemStack, sinkHandler);
    }

    public static ItemStack getSinkOutput(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (Map.Entry<ItemStack, SinkHandler> entry : sinkHandlers.entrySet()) {
            if (!entry.getKey().func_77969_a(itemStack)) continue;
            return entry.getValue().getSinkOutput(itemStack);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    private static SourceItem findAnyItemStack(ItemStack checkStack, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (checkStack.func_190926_b()) {
            return null;
        }
        for (int i = 0; i < inventories.size(); ++i) {
            IngredientPredicate predicate;
            IKitchenItemProvider itemProvider = inventories.get(i);
            SourceItem found = itemProvider.findSource(predicate = (it, count) -> it.func_185136_b(checkStack) && count > 0, 1, inventories, requireBucket, true);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static List<SourceItem> findSourceCandidates(FoodIngredient ingredient, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean isNoFilter) {
        SourceItem sourceItem;
        ItemStack[] variants;
        ArrayList<SourceItem> sourceList = new ArrayList<SourceItem>();
        for (ItemStack checkStack : variants = ingredient.getItemStacks()) {
            ItemStack foundStack;
            SourceItem sourceItem2 = CookingRegistry.findAnyItemStack(checkStack, inventories, requireBucket);
            ItemStack itemStack = foundStack = sourceItem2 != null ? sourceItem2.getSourceStack() : ItemStack.field_190927_a;
            if (foundStack.func_190926_b() && (isNoFilter || ingredient.isToolItem())) {
                sourceItem2 = new SourceItem(null, -1, checkStack);
            }
            if (sourceItem2 == null) continue;
            sourceList.add(sourceItem2);
        }
        SourceItem sourceItem3 = sourceItem = !sourceList.isEmpty() ? (SourceItem)sourceList.get(0) : null;
        if (sourceItem != null && sourceItem.getSourceProvider() != null) {
            sourceItem.getSourceProvider().markAsUsed(sourceItem, 1, inventories, requireBucket);
        }
        return sourceList;
    }

    public static boolean consumeBucket(List<IKitchenItemProvider> inventories, boolean simulate) {
        ItemStack bucketStack = new ItemStack((IItemProvider)Items.field_151133_ar);
        for (int i = 0; i < inventories.size(); ++i) {
            IngredientPredicate predicate;
            IKitchenItemProvider itemProvider = inventories.get(i);
            SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(predicate = (it, count) -> it.func_77969_a(bucketStack) && count > 0, 1, inventories, false, simulate);
            if (sourceItem == null) continue;
            return true;
        }
        return false;
    }

    public static RecipeStatus getRecipeStatus(FoodRecipe recipe, List<IKitchenItemProvider> inventories, boolean hasOven) {
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        List<FoodIngredient> craftMatrix = recipe.getCraftMatrix();
        boolean missingTools = false;
        for (FoodIngredient ingredient : craftMatrix) {
            if (ingredient == null) continue;
            List<SourceItem> sourceList = CookingRegistry.findSourceCandidates(ingredient, inventories, requireBucket, false);
            if (sourceList.isEmpty()) {
                return RecipeStatus.MISSING_INGREDIENTS;
            }
            if (!sourceList.stream().allMatch(it -> it.getSourceProvider() == null)) continue;
            missingTools = true;
        }
        if (recipe.getType() == RecipeType.SMELTING && !hasOven) {
            return RecipeStatus.MISSING_TOOLS;
        }
        return missingTools ? RecipeStatus.MISSING_TOOLS : RecipeStatus.AVAILABLE;
    }

    public static List<IKitchenItemProvider> getItemProviders(@Nullable KitchenMultiBlock multiBlock, PlayerInventory inventory) {
        return multiBlock != null ? multiBlock.getItemProviders(inventory) : Lists.newArrayList((Object[])new IKitchenItemProvider[]{new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)inventory))});
    }

    @Nullable
    public static IRecipe findFoodRecipe(InventoryCraftBook craftMatrix, World world, IRecipeType<?> recipeType, Item expectedItem) {
        for (IRecipe<IInventory> recipe : recipeList) {
            if (recipe.func_222127_g() != recipeType || !recipe.func_77569_a((IInventory)craftMatrix, world) || recipe.func_77571_b().func_77973_b() != expectedItem) continue;
            return recipe;
        }
        return null;
    }

    public static void addWaterItem(ItemStack waterItem) {
        waterItems.add((Object)waterItem);
    }

    public static void addMilkItem(ItemStack milkItem) {
        milkItems.add((Object)milkItem);
    }

    public static void addSortButton(ISortButton button) {
        customSortButtons.add(button);
    }

    public static NonNullList<ItemStack> getWaterItems() {
        return waterItems;
    }

    public static NonNullList<ItemStack> getMilkItems() {
        return milkItems;
    }

    public static List<ISortButton> getSortButtons() {
        return customSortButtons;
    }

    public static boolean doesItemRequireBucketForCrafting(ItemStack outputItem) {
        ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)outputItem);
        if (!containerItem.func_190926_b() && containerItem.func_77973_b() == Items.field_151133_ar) {
            return true;
        }
        ResourceLocation registryName = outputItem.func_77973_b().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("bucket");
    }
}

