/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.FridgeTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.items.IItemHandler;

public class FridgeRenderer
extends TileEntityRenderer<FridgeTileEntity> {
    private static final Random random = new Random();

    public FridgeRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FridgeTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = tileEntity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = tileEntity.func_195044_w();
        FridgeBlock.FridgeModelType fridgeModelType = (FridgeBlock.FridgeModelType)((Object)state.func_177229_b(FridgeBlock.MODEL_TYPE));
        if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_UPPER) {
            return;
        }
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        this.renderDoor(world, tileEntity, matrixStack, buffer, state, fridgeModelType, doorAngle);
        if (doorAngle > 0.0f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(matrixStack, tileEntity.func_195044_w());
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            float topY = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER ? 3.25f : 0.45f;
            IItemHandler itemHandler = tileEntity.getCombinedItemHandler();
            for (int i = itemHandler.getSlots() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                int rowIndex;
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.func_190926_b()) continue;
                if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)((int)((float)i / 18.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)((int)((float)i / 14.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                }
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)offsetX, (double)offsetY, (double)offsetZ);
                matrixStack.func_227863_a_(new Quaternion(0.0f, 45.0f, 0.0f, true));
                RenderUtils.renderItem(itemStack, combinedLight, matrixStack, buffer);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
    }

    private void renderDoor(World world, FridgeTileEntity tileEntity, MatrixStack matrixStack, IRenderTypeBuffer buffer, BlockState state, FridgeBlock.FridgeModelType fridgeModelType, float doorAngle) {
        IBakedModel lowerModel;
        boolean isFlipped = (Boolean)state.func_177229_b((Property)FridgeBlock.FLIPPED);
        boolean isLarge = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER;
        matrixStack.func_227860_a_();
        RenderUtils.applyBlockAngle(matrixStack, tileEntity.func_195044_w());
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        float originX = 0.90625f;
        float originZ = 0.09375f;
        if (isFlipped) {
            originX = 1.0f - originX;
            doorAngle *= -1.0f;
        }
        matrixStack.func_227861_a_((double)originX, 0.0, (double)originZ);
        matrixStack.func_227863_a_(new Quaternion(0.0f, -((float)Math.toDegrees(doorAngle)), 0.0f, true));
        matrixStack.func_227861_a_((double)(-originX), 0.0, (double)(-originZ));
        IBakedModel upperModel = null;
        if (isLarge) {
            lowerModel = isFlipped ? ModModels.fridgeDoorLargeLowerFlipped : ModModels.fridgeDoorLargeLower;
            upperModel = isFlipped ? ModModels.fridgeDoorLargeUpperFlipped : ModModels.fridgeDoorLargeUpper;
        } else {
            lowerModel = isFlipped ? ModModels.fridgeDoorFlipped : ModModels.fridgeDoor;
        }
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        dispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, lowerModel, tileEntity.func_195044_w(), tileEntity.func_174877_v(), matrixStack, buffer.getBuffer(RenderType.func_228639_c_()), false, random, 0L, 0, (IModelData)EmptyModelData.INSTANCE);
        if (upperModel != null) {
            matrixStack.func_227861_a_(0.0, 1.0, 0.0);
            dispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, upperModel, tileEntity.func_195044_w(), tileEntity.func_174877_v().func_177984_a(), matrixStack, buffer.getBuffer(RenderType.func_228639_c_()), false, random, 0L, 0, (IModelData)EmptyModelData.INSTANCE);
        }
        matrixStack.func_227865_b_();
    }
}

