/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.CounterTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.items.IItemHandler;

public class CounterRenderer
extends TileEntityRenderer<CounterTileEntity> {
    private static final Random random = new Random();
    private static final float doorOriginX = 0.84375f;
    private static final float doorOriginZ = 0.09375f;

    public CounterRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    protected float getDoorOriginX() {
        return 0.84375f;
    }

    protected float getDoorOriginZ() {
        return 0.09375f;
    }

    protected float getBottomShelfOffsetY() {
        return -0.85f;
    }

    protected float getTopShelfOffsetY() {
        return 0.35f;
    }

    protected IBakedModel getDoorModel(@Nullable DyeColor blockColor, boolean isFlipped) {
        int colorIndex = blockColor != null ? blockColor.func_196059_a() + 1 : 0;
        return isFlipped ? ModModels.counterDoorsFlipped[colorIndex] : ModModels.counterDoors[colorIndex];
    }

    public void render(CounterTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = tileEntity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = tileEntity.func_195044_w();
        boolean hasColor = (Boolean)state.func_177229_b((Property)BlockKitchen.HAS_COLOR);
        DyeColor blockColor = hasColor ? (DyeColor)state.func_177229_b(BlockKitchen.COLOR) : null;
        float blockAngle = tileEntity.getFacing().func_185119_l();
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        boolean isFlipped = tileEntity.isFlipped();
        matrixStack.func_227860_a_();
        float doorOriginX = this.getDoorOriginX();
        float doorOriginZ = this.getDoorOriginZ();
        float doorDirection = -1.0f;
        if (isFlipped) {
            doorOriginX = 1.0f - doorOriginX;
            doorDirection = 1.0f;
        }
        RenderUtils.applyBlockAngle(matrixStack, tileEntity.func_195044_w());
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        matrixStack.func_227861_a_((double)doorOriginX, 0.0, (double)doorOriginZ);
        matrixStack.func_227863_a_(new Quaternion(0.0f, doorDirection * (float)Math.toDegrees(doorAngle), 0.0f, true));
        matrixStack.func_227861_a_((double)(-doorOriginX), 0.0, (double)(-doorOriginZ));
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = this.getDoorModel(blockColor, isFlipped);
        dispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, model, tileEntity.func_195044_w(), tileEntity.func_174877_v(), matrixStack, buffer.getBuffer(RenderType.func_228639_c_()), false, random, 0L, 0, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        if (doorAngle > 0.0f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(matrixStack, tileEntity.func_195044_w());
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            IItemHandler itemHandler = tileEntity.getItemHandler();
            int itemsPerShelf = itemHandler.getSlots() / 2;
            int itemsPerRow = itemsPerShelf / 2;
            for (int i = itemHandler.getSlots() - 1; i >= 0; --i) {
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.func_190926_b()) continue;
                int shelfIndex = i % itemsPerShelf;
                int rowIndex = i % itemsPerRow;
                float spacing = 2.0f / (float)itemsPerRow;
                float offsetX = ((float)rowIndex - (float)itemsPerRow / 2.0f) * -spacing + (shelfIndex >= itemsPerRow ? -0.2f : 0.0f);
                float offsetY = i < itemsPerShelf ? this.getTopShelfOffsetY() : this.getBottomShelfOffsetY();
                float offsetZ = shelfIndex < itemsPerRow ? 0.5f : -0.5f;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)offsetX, (double)offsetY, (double)offsetZ);
                matrixStack.func_227863_a_(new Quaternion(0.0f, 45.0f, 0.0f, true));
                RenderUtils.renderItem(itemStack, combinedLight, matrixStack, buffer);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
    }
}

