/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.OvenTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class OvenBlock
extends BlockKitchen {
    public static BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final String name = "oven";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "oven");
    private static final Random random = new Random();

    public OvenBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 10.0f), registryName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED, ACTIVE});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (rayTraceResult.func_216354_b() == Direction.UP && CookingRegistry.isToolItem(heldItem)) {
            OvenTileEntity tileOven;
            Direction stateFacing = (Direction)state.func_177229_b((Property)FACING);
            double hx = rayTraceResult.func_216347_e().field_72450_a;
            double hz = rayTraceResult.func_216347_e().field_72449_c;
            switch (stateFacing) {
                case NORTH: {
                    hx = 1.0 - rayTraceResult.func_216347_e().field_72450_a;
                    hz = 1.0 - rayTraceResult.func_216347_e().field_72449_c;
                    break;
                }
                case WEST: {
                    hz = 1.0 - rayTraceResult.func_216347_e().field_72450_a;
                    hx = rayTraceResult.func_216347_e().field_72449_c;
                    break;
                }
                case EAST: {
                    hz = rayTraceResult.func_216347_e().field_72450_a;
                    hx = 1.0 - rayTraceResult.func_216347_e().field_72449_c;
                }
            }
            int index = -1;
            if (hx < 0.5 && hz < 0.5) {
                index = 1;
            } else if (hx >= 0.5 && hz < 0.5) {
                index = 0;
            } else if (hx < 0.5 && hz >= 0.5) {
                index = 3;
            } else if (hx >= 0.5 && hz >= 0.5) {
                index = 2;
            }
            if (index != -1 && (tileOven = (OvenTileEntity)world.func_175625_s(pos)) != null && tileOven.getToolItem(index).func_190926_b()) {
                ItemStack toolItem = heldItem.func_77979_a(1);
                tileOven.setToolItem(index, toolItem);
            }
            return ActionResultType.SUCCESS;
        }
        OvenTileEntity tileEntity = (OvenTileEntity)world.func_175625_s(pos);
        if (rayTraceResult.func_216354_b() == state.func_177229_b((Property)FACING) && tileEntity != null) {
            if (player.func_225608_bj_()) {
                tileEntity.getDoorAnimator().toggleForcedOpen();
                return ActionResultType.SUCCESS;
            }
            if (!heldItem.func_190926_b() && tileEntity.getDoorAnimator().isForcedOpen()) {
                heldItem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileEntity.getInputHandler(), (ItemStack)heldItem, (boolean)false);
                if (!heldItem.func_190926_b()) {
                    heldItem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileEntity.getItemHandlerFuel(), (ItemStack)heldItem, (boolean)false);
                }
                player.func_184611_a(hand, heldItem);
                return ActionResultType.SUCCESS;
            }
        }
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OvenTileEntity();
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        OvenTileEntity tileEntity = (OvenTileEntity)world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.isBurning()) {
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            float x = (float)pos.func_177958_n() + 0.5f;
            float y = (float)pos.func_177956_o() + 0.0f + OvenBlock.random.nextFloat() * 6.0f / 16.0f;
            float z = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = OvenBlock.random.nextFloat() * 0.6f - 0.3f;
            if (facing == Direction.WEST) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(x - f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.EAST) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(x + f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(x + f4), (double)y, (double)(z - f3), 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)(x + f4), (double)y, (double)(z + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (newState.func_177230_c() != state.func_177230_c() && (tileEntity = world.func_175625_s(pos)) instanceof OvenTileEntity && ((OvenTileEntity)tileEntity).hasPowerUpgrade()) {
            ItemUtils.spawnItemStack(world, (float)pos.func_177958_n() + 0.5f, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ModItems.heatingUnit));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }
}

