/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.KitchenCornerBlock;
import net.blay09.mods.cookingforblockheads.block.KitchenCounterBlock;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class BlockKitchen
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LOWERED = BooleanProperty.func_177716_a((String)"lowered");
    public static final BooleanProperty FLIPPED = BooleanProperty.func_177716_a((String)"flipped");
    public static final BooleanProperty HAS_COLOR = BooleanProperty.func_177716_a((String)"has_color");
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.func_177709_a((String)"color", DyeColor.class);
    private static final VoxelShape BOUNDING_BOX_X = Block.func_208617_a((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)15.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_Z = Block.func_208617_a((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)15.0, (double)15.5);
    private final ResourceLocation registryName;

    protected BlockKitchen(AbstractBlock.Properties properties, ResourceLocation registryName) {
        super(properties);
        this.registryName = registryName;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X) {
            return BOUNDING_BOX_X;
        }
        return BOUNDING_BOX_Z;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
        if (state.func_235901_b_((Property)LOWERED)) {
            state = (BlockState)state.func_206870_a((Property)LOWERED, (Comparable)Boolean.valueOf(BlockKitchen.shouldBeLoweredUpon(context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()))));
        }
        return state.func_235901_b_((Property)HAS_COLOR) ? (BlockState)state.func_206870_a((Property)HAS_COLOR, (Comparable)Boolean.valueOf(false)) : state;
    }

    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:multiblock_kitchen", TextFormatting.YELLOW));
        if (this.hasTooltipDescription()) {
            for (String s : I18n.func_135052_a((String)("tooltip." + this.registryName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
                tooltip.add(TextUtils.coloredTextComponent(s, TextFormatting.GRAY));
            }
        }
        if (this.isDyeable()) {
            tooltip.add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:dyeable", TextFormatting.AQUA));
        }
    }

    protected boolean hasTooltipDescription() {
        return true;
    }

    protected boolean isDyeable() {
        return false;
    }

    public static boolean shouldBlockRenderLowered(IBlockReader world, BlockPos pos) {
        return BlockKitchen.shouldBeLoweredUpon(world.func_180495_p(pos.func_177977_b()));
    }

    private static boolean shouldBeLoweredUpon(BlockState stateBelow) {
        Block blockBelow = stateBelow.func_177230_c();
        return blockBelow instanceof KitchenCounterBlock || blockBelow instanceof KitchenCornerBlock;
    }

    public boolean shouldBePlacedFlipped(BlockItemUseContext context, Direction facing) {
        BlockPos pos = context.func_195995_a();
        PlayerEntity placer = context.func_195999_j();
        if (placer == null) {
            return Math.random() < 0.5;
        }
        double dir = 0.0;
        if (facing.func_176740_k() == Direction.Axis.Z) {
            dir = (double)((float)pos.func_177958_n() + 0.5f) - placer.func_226277_ct_();
            dir *= -1.0;
        } else if (facing.func_176740_k() == Direction.Axis.X) {
            dir = (double)((float)pos.func_177952_p() + 0.5f) - placer.func_226281_cx_();
        }
        boolean flipped = facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? dir < 0.0 : dir > 0.0;
        return flipped;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && state.func_177230_c() != newState.func_177230_c()) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> ItemUtils.dropItemHandlerItems(world, pos, itemHandler));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean tryRecolorBlock(BlockState state, ItemStack heldItem, World world, BlockPos pos, PlayerEntity player, BlockRayTraceResult rayTraceResult) {
        if (heldItem.func_77973_b() == Items.field_196106_bc && this.removeColor(state, (IWorld)world, pos, rayTraceResult.func_216354_b())) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color != null) {
            if (this.recolorBlock(state, (IWorld)world, pos, rayTraceResult.func_216354_b(), color) && !player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private boolean removeColor(BlockState state, IWorld world, BlockPos pos, Direction facing) {
        if (state.func_235901_b_(COLOR) && state.func_235901_b_((Property)HAS_COLOR) && ((Boolean)state.func_177229_b((Property)HAS_COLOR)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_COLOR, (Comparable)Boolean.valueOf(false)), 3);
            return true;
        }
        return false;
    }

    private boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, Direction facing, DyeColor color) {
        DyeColor current;
        if (state.func_235901_b_(COLOR) && state.func_235901_b_((Property)HAS_COLOR) && ((current = (DyeColor)state.func_177229_b(COLOR)) != color || !((Boolean)state.func_177229_b((Property)HAS_COLOR)).booleanValue())) {
            world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(COLOR, (Comparable)color)).func_206870_a((Property)HAS_COLOR, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && state.func_235901_b_((Property)LOWERED)) {
            return (BlockState)state.func_206870_a((Property)LOWERED, (Comparable)Boolean.valueOf(BlockKitchen.shouldBeLoweredUpon(facingState)));
        }
        return state;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_189539_a(BlockState p_189539_1_, World world, BlockPos pos, int id, int param) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            return tileEntity.func_145842_c(id, param);
        }
        return false;
    }
}

