/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.blay09.mods.cookingforblockheads.api.IKitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class KitchenMultiBlock
implements IKitchenMultiBlock {
    private static final List<Block> blockConnectors = new ArrayList<Block>();
    private final Set<BlockPos> checkedPos = Sets.newHashSet();
    private final List<IKitchenItemProvider> itemProviderList = Lists.newArrayList();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = Lists.newArrayList();

    private KitchenMultiBlock(World world, BlockPos pos) {
        this.findNeighbourKitchenBlocks(world, pos, true);
    }

    public static KitchenMultiBlock buildFromLocation(World world, BlockPos pos) {
        return new KitchenMultiBlock(world, pos);
    }

    private void findNeighbourKitchenBlocks(World world, BlockPos pos, boolean extendedUpSearch) {
        for (Direction direction : Direction.values()) {
            int upSearch = extendedUpSearch && direction == Direction.UP ? 2 : 1;
            for (int n = 1; n <= upSearch; ++n) {
                BlockPos position = pos.func_177967_a(direction, n);
                if (this.checkedPos.contains(position)) continue;
                this.checkedPos.add(position);
                TileEntity tileEntity = world.func_175625_s(position);
                if (tileEntity != null) {
                    LazyOptional itemProviderCap = tileEntity.getCapability(CapabilityKitchenItemProvider.CAPABILITY);
                    itemProviderCap.ifPresent(this.itemProviderList::add);
                    LazyOptional smeltingProviderCap = tileEntity.getCapability(CapabilityKitchenSmeltingProvider.CAPABILITY);
                    smeltingProviderCap.ifPresent(this.smeltingProviderList::add);
                    if (!itemProviderCap.isPresent() && !smeltingProviderCap.isPresent() && !tileEntity.getCapability(CapabilityKitchenConnector.CAPABILITY).isPresent()) continue;
                    this.findNeighbourKitchenBlocks(world, position, true);
                    continue;
                }
                BlockState state = world.func_180495_p(position);
                if (state.isAir((IBlockReader)world, position) || !blockConnectors.contains(state.func_177230_c())) continue;
                this.findNeighbourKitchenBlocks(world, position, false);
            }
        }
    }

    public static void registerConnectorBlock(Block block) {
        blockConnectors.add(block);
    }

    @Override
    public List<IKitchenItemProvider> getItemProviders(PlayerInventory playerInventory) {
        ArrayList sourceInventories = Lists.newArrayList();
        sourceInventories.addAll(this.itemProviderList);
        sourceInventories.add(new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)playerInventory)));
        return sourceInventories;
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack, int count) {
        IKitchenSmeltingProvider provider;
        ItemStack restStack = itemStack.func_77946_l().func_77979_a(count);
        Iterator<IKitchenSmeltingProvider> iterator = this.smeltingProviderList.iterator();
        while (iterator.hasNext() && !(restStack = (provider = iterator.next()).smeltItem(restStack)).func_190926_b()) {
        }
        return restStack;
    }

    public void trySmelt(ItemStack outputItem, ItemStack inputItem, PlayerEntity player, boolean stack) {
        if (inputItem.func_190926_b()) {
            return;
        }
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = this.getItemProviders(player.field_71071_by);
        for (IKitchenItemProvider itemProvider : inventories) {
            int amount;
            itemProvider.resetSimulation();
            IngredientPredicate predicate = (it, count) -> it.func_77969_a(inputItem) && count > 0;
            int count2 = stack ? inputItem.func_77976_d() : 1;
            SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(predicate, count2, inventories, requireBucket, false);
            if (sourceItem == null) continue;
            ItemStack sourceStack = sourceItem.getSourceStack();
            ItemStack restStack = this.smeltItem(sourceStack, amount = Math.min(sourceStack.func_190916_E(), count2));
            if (!restStack.func_190926_b() && !player.field_71071_by.func_70441_a(restStack = itemProvider.returnItemStack(restStack, sourceItem))) {
                player.func_71019_a(restStack, false);
            }
            player.field_71070_bA.func_75142_b();
            return;
        }
    }

    @Override
    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }
}

