/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import java.util.Objects;
import net.blay09.mods.cookingforblockheads.CommonProxy;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.CowJarHandler;
import net.blay09.mods.cookingforblockheads.IMCHandler;
import net.blay09.mods.cookingforblockheads.InternalMethods;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.client.ClientProxy;
import net.blay09.mods.cookingforblockheads.client.ModRenderers;
import net.blay09.mods.cookingforblockheads.client.ModScreens;
import net.blay09.mods.cookingforblockheads.client.gui.HungerSortButton;
import net.blay09.mods.cookingforblockheads.client.gui.NameSortButton;
import net.blay09.mods.cookingforblockheads.client.gui.SaturationSortButton;
import net.blay09.mods.cookingforblockheads.compat.VanillaAddon;
import net.blay09.mods.cookingforblockheads.compat.json.JsonCompatLoader;
import net.blay09.mods.cookingforblockheads.container.ModContainers;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="cookingforblockheads")
public class CookingForBlockheads {
    public static final String MOD_ID = "cookingforblockheads";
    public static final Logger logger = LogManager.getLogger((String)"cookingforblockheads");
    public static final NonNullList<ItemStack> extraItemGroupItems = NonNullList.func_191196_a();
    public static final ItemGroup itemGroup = new ItemGroup("cookingforblockheads"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.recipeBook);
        }

        public void func_78018_a(NonNullList<ItemStack> list) {
            super.func_78018_a(list);
            list.addAll(extraItemGroupItems);
        }
    };
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public CookingForBlockheads() {
        DeferredWorkQueue.runLater(NetworkHandler::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::recipesUpdated);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CookingForBlockheadsConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CookingForBlockheadsConfig.clientSpec);
        CookingForBlockheadsAPI.setupAPI(new InternalMethods());
        CookingRegistry.addSortButton(new NameSortButton());
        CookingRegistry.addSortButton(new HungerSortButton());
        CookingRegistry.addSortButton(new SaturationSortButton());
        MinecraftForge.EVENT_BUS.register((Object)new IMCHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CowJarHandler());
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityKitchenConnector.register();
        CapabilityKitchenItemProvider.register();
        CapabilityKitchenSmeltingProvider.register();
        this.initializeAddons();
    }

    private void setupClient(FMLClientSetupEvent event) {
        ModScreens.register();
        ModRenderers.register();
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new JsonCompatLoader());
    }

    private void serverStarted(FMLServerStartedEvent event) {
        RecipeManager recipeManager = event.getServer().func_199529_aN();
        CookingRegistry.initFoodRegistry(recipeManager);
    }

    private void recipesUpdated(RecipesUpdatedEvent event) {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        RecipeManager recipeManager = Objects.requireNonNull(connection).func_199526_e();
        CookingRegistry.initFoodRegistry(recipeManager);
    }

    public void initializeAddons() {
        new VanillaAddon();
        if (ModList.get().isLoaded("harvestcraft")) {
            try {
                Class.forName("net.blay09.mods.cookingforblockheads.compat.HarvestCraftAddon").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (ModList.get().isLoaded("applecore")) {
            try {
                Class.forName("net.blay09.mods.cookingforblockheads.compat.AppleCoreAddon").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void enqueueIMC(InterModEnqueueEvent event) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        ModTileEntities.registerTileEntities(event.getRegistry());
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        ModContainers.registerContainers(event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.register((IForgeRegistry<SoundEvent>)event.getRegistry());
    }
}

