/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderUniformCache;
import codechicken.lib.render.shader.UniformCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.lwjgl.opengl.GL20;

public class ShaderProgram
implements ISelectiveResourceReloadListener {
    private final List<ShaderObject> shaders;
    private final Consumer<UniformCache> cacheCallback;
    private final ShaderUniformCache uniformCache;
    private int programId = -1;
    private boolean bound;

    public ShaderProgram(Collection<ShaderObject> shaders) {
        this(shaders, e -> {});
    }

    public ShaderProgram(Collection<ShaderObject> shaders, Consumer<UniformCache> cacheCallback) {
        this.shaders = new ArrayList<ShaderObject>(shaders);
        this.cacheCallback = cacheCallback;
        this.uniformCache = new ShaderUniformCache(this);
    }

    public List<ShaderObject> getShaders() {
        return Collections.unmodifiableList(this.shaders);
    }

    public int getProgramId() {
        return this.programId;
    }

    public UniformCache pushCache() {
        ShaderUniformCache cache = this.uniformCache.pushCache();
        this.cacheCallback.accept(cache);
        return cache;
    }

    public void use() {
        if (this.bound) {
            throw new IllegalStateException("Already bound.");
        }
        if (this.programId == -1 || this.shaders.stream().anyMatch(ShaderObject::isDirty)) {
            this.shaders.forEach(ShaderObject::alloc);
            if (this.programId == -1) {
                this.programId = GL20.glCreateProgram();
                if (this.programId == 0) {
                    throw new IllegalStateException("Allocation of ShaderProgram has failed.");
                }
                this.shaders.forEach(shader -> GL20.glAttachShader((int)this.programId, (int)shader.getShaderID()));
            }
            GL20.glLinkProgram((int)this.programId);
            if (GL20.glGetProgrami((int)this.programId, (int)35714) == 0) {
                throw new RuntimeException("ShaderProgram linkage failure. \n" + GL20.glGetProgramInfoLog((int)this.programId));
            }
            this.shaders.forEach(shader -> shader.onLink(this.programId));
            this.uniformCache.onLink();
        }
        GL20.glUseProgram((int)this.programId);
        this.bound = true;
    }

    public void popCache(UniformCache cache) {
        if (!this.bound) {
            throw new IllegalStateException("Not bound");
        }
        this.uniformCache.popApply((ShaderUniformCache)cache);
    }

    public void release() {
        if (!this.bound) {
            throw new IllegalStateException("Not bound");
        }
        this.bound = false;
        GL20.glUseProgram((int)0);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        for (ShaderObject shader : this.shaders) {
            if (!(shader instanceof ISelectiveResourceReloadListener)) continue;
            ((ISelectiveResourceReloadListener)shader).onResourceManagerReload(resourceManager, resourcePredicate);
        }
    }
}

