/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;

public class LightingAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = new AttributeKey<int[]>("lighting", int[]::new);
    private int[] colourRef;

    public LightingAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        if (!(ccrs.computeLighting && ccrs.fmt.hasColor() && ccrs.model.hasAttribute(attributeKey))) {
            return false;
        }
        this.colourRef = ccrs.model.getAttributes(attributeKey);
        if (this.colourRef != null) {
            ccrs.pipeline.addDependency(ccrs.colourAttrib);
            return true;
        }
        return false;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        ccrs.colour = ColourRGBA.multiply(ccrs.colour, this.colourRef[ccrs.vertexIndex]);
    }
}

