/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.VertexAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CCRenderPipeline {
    private final CCRenderState renderState;
    @Deprecated
    private final PipelineBuilder builder;
    @Deprecated
    public boolean forceFormatAttributes = true;
    private final List<VertexAttribute<?>> attribs = new ArrayList();
    private final List<IVertexOperation> ops = new ArrayList<IVertexOperation>();
    private final List<PipelineNode> nodes = new ArrayList<PipelineNode>();
    private final List<IVertexOperation> sorted = new ArrayList<IVertexOperation>();
    private PipelineNode loading;

    public CCRenderPipeline(CCRenderState renderState) {
        this.renderState = renderState;
        this.builder = new PipelineBuilder(renderState);
    }

    public void setPipeline(IVertexOperation ... ops) {
        this.ops.clear();
        Collections.addAll(this.ops, ops);
        this.rebuild();
    }

    public void reset() {
        this.ops.clear();
        this.unbuild();
    }

    private void unbuild() {
        for (int i = 0; i < this.attribs.size(); ++i) {
            VertexAttribute<?> attrib = this.attribs.get(i);
            attrib.active = false;
        }
        this.attribs.clear();
        this.sorted.clear();
    }

    public void rebuild() {
        int i;
        if (this.ops.isEmpty() || this.renderState.model == null) {
            return;
        }
        while (this.nodes.size() < IVertexOperation.operationCount()) {
            this.nodes.add(new PipelineNode());
        }
        this.unbuild();
        if (this.renderState.fmt.hasNormal()) {
            this.addAttribute(this.renderState.normalAttrib);
        }
        if (this.renderState.fmt.hasColor()) {
            this.addAttribute(this.renderState.colourAttrib);
        }
        if (this.renderState.computeLighting) {
            this.addAttribute(this.renderState.lightingAttrib);
        }
        for (i = 0; i < this.ops.size(); ++i) {
            IVertexOperation op = this.ops.get(i);
            this.loading = this.nodes.get(op.operationID());
            boolean loaded = op.load(this.renderState);
            if (loaded) {
                this.loading.op = op;
            }
            if (!(op instanceof VertexAttribute)) continue;
            if (loaded) {
                this.attribs.add((VertexAttribute)op);
                continue;
            }
            ((VertexAttribute)op).active = false;
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            PipelineNode node = this.nodes.get(i);
            node.add();
        }
    }

    public void addRequirement(int opRef) {
        this.loading.deps.add(this.nodes.get(opRef));
    }

    public void addDependency(VertexAttribute<?> attrib) {
        this.loading.deps.add(this.nodes.get(attrib.operationID()));
        this.addAttribute(attrib);
    }

    public void addAttribute(VertexAttribute<?> attrib) {
        if (!attrib.active) {
            this.ops.add(attrib);
            attrib.active = true;
        }
    }

    public void operate() {
        for (int i = 0; i < this.sorted.size(); ++i) {
            IVertexOperation aSorted = this.sorted.get(i);
            aSorted.operate(this.renderState);
        }
    }

    @Deprecated
    public PipelineBuilder builder() {
        this.ops.clear();
        return this.builder;
    }

    private class PipelineNode {
        public ArrayList<PipelineNode> deps = new ArrayList();
        public IVertexOperation op;

        private PipelineNode() {
        }

        public void add() {
            if (this.op == null) {
                return;
            }
            for (int i = 0; i < this.deps.size(); ++i) {
                PipelineNode dep = this.deps.get(i);
                dep.add();
            }
            this.deps.clear();
            CCRenderPipeline.this.sorted.add(this.op);
            this.op = null;
        }
    }

    @Deprecated
    public class PipelineBuilder {
        private final CCRenderState renderState;

        public PipelineBuilder(CCRenderState renderState) {
            this.renderState = renderState;
        }

        public PipelineBuilder add(IVertexOperation op) {
            CCRenderPipeline.this.ops.add(op);
            return this;
        }

        public PipelineBuilder add(IVertexOperation ... ops) {
            Collections.addAll(CCRenderPipeline.this.ops, ops);
            return this;
        }

        public void build() {
            CCRenderPipeline.this.rebuild();
        }

        public void render() {
            CCRenderPipeline.this.rebuild();
            this.renderState.render();
        }
    }
}

