/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.RecipeBuilder;
import codechicken.lib.util.SneakyUtils;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public abstract class AbstractRecipeBuilder<R, T extends AbstractRecipeBuilder<R, T>>
implements RecipeBuilder {
    protected final Throwable created = new Throwable("Created at");
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    protected final IRecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final R result;
    private final Set<IItemProvider> criteriaItems = new HashSet<IItemProvider>();
    private final Set<Tag<Item>> criteriaTags = new HashSet<Tag<Item>>();
    private int criteriaCounter = 0;
    protected boolean generateCriteria = false;
    protected boolean enableUnlocking = false;
    private String group;

    protected AbstractRecipeBuilder(IRecipeSerializer<?> serializer, ResourceLocation id, R result) {
        this.serializer = serializer;
        this.id = id;
        this.result = result;
    }

    protected T getThis() {
        return (T)((AbstractRecipeBuilder)SneakyUtils.unsafeCast(this));
    }

    protected abstract ResourceLocation getAdvancementId();

    public T enableUnlocking() {
        this.enableUnlocking = true;
        return this.getThis();
    }

    public T autoCriteria() {
        this.enableUnlocking();
        this.generateCriteria = true;
        return this.getThis();
    }

    public T setGroup(String group) {
        this.group = group;
        return this.getThis();
    }

    public T addCriterion(String name, ICriterionInstance criterion) {
        if (!this.enableUnlocking) {
            throw new IllegalStateException("Recipe unlocking must be enabled with 'enableUnlocking'");
        }
        this.advancementBuilder.func_200275_a(name, criterion);
        return this.getThis();
    }

    @Override
    public final ResourceLocation getId() {
        return this.id;
    }

    @Override
    public final IFinishedRecipe build() {
        this.validate();
        if (this.enableUnlocking) {
            this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)this.id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)this.id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        return this._build();
    }

    protected void validate() {
        if (this.enableUnlocking && this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + this.id, this.created);
        }
    }

    protected abstract AbstractFinishedRecipe _build();

    protected void addAutoCriteria(IItemProvider item) {
        if (this.generateCriteria && this.criteriaItems.add(item)) {
            this.addCriterion("has_ingredient_" + this.criteriaCounter++, (ICriterionInstance)this.hasItem(item));
        }
    }

    protected void addAutoCriteria(Tag<Item> tag) {
        if (this.generateCriteria && this.criteriaTags.add(tag)) {
            this.addCriterion("has_ingredient_" + this.criteriaCounter++, (ICriterionInstance)this.hasItem(tag));
        }
    }

    protected InventoryChangeTrigger.Instance hasItem(IItemProvider itemIn) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200308_a(itemIn).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(Tag<Item> tagIn) {
        return this.hasItem(ItemPredicate.Builder.func_200309_a().func_200307_a(tagIn).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }

    public abstract class AbstractFinishedRecipe
    implements IFinishedRecipe {
        public void func_218610_a(JsonObject json) {
            if (!StringUtils.func_151246_b((String)AbstractRecipeBuilder.this.group)) {
                json.addProperty("group", AbstractRecipeBuilder.this.group);
            }
        }

        public IRecipeSerializer<?> func_218609_c() {
            return AbstractRecipeBuilder.this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return AbstractRecipeBuilder.this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return AbstractRecipeBuilder.this.enableUnlocking ? AbstractRecipeBuilder.this.advancementBuilder.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return AbstractRecipeBuilder.this.getAdvancementId();
        }
    }
}

