/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.projector;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class MultiblockProjection {
    final MultiblockHandler.IMultiblock multiblock;
    final IMultiblockBlockReader blockAccess;
    final PlacementSettings settings = new PlacementSettings();
    final Int2ObjectMap<List<Template.BlockInfo>> layers = new Int2ObjectArrayMap();
    final int blockcount;
    final BlockPos.Mutable offset = new BlockPos.Mutable();
    boolean isDirty = true;
    World world;

    public MultiblockProjection(World world, @Nonnull MultiblockHandler.IMultiblock multiblock) {
        Objects.requireNonNull(multiblock, "Multiblock cannot be null!");
        this.world = world;
        this.multiblock = multiblock;
        this.blockAccess = MultiblockProjection.getBlockAccessFor(this.multiblock);
        List blocks = multiblock.getStructure(this.world);
        this.blockcount = blocks.size();
        for (Template.BlockInfo info : blocks) {
            ArrayList<Template.BlockInfo> list = (ArrayList<Template.BlockInfo>)this.layers.get(info.field_186242_a.func_177956_o());
            if (list == null) {
                list = new ArrayList<Template.BlockInfo>();
                this.layers.put(info.field_186242_a.func_177956_o(), list);
            }
            list.add(info);
        }
    }

    public MultiblockProjection setRotation(Rotation rotation) {
        if (this.settings.func_186215_c() != rotation) {
            this.settings.func_186220_a(rotation);
            this.isDirty = true;
        }
        return this;
    }

    public MultiblockProjection setFlip(boolean mirror) {
        Mirror m;
        Mirror mirror2 = m = mirror ? Mirror.FRONT_BACK : Mirror.NONE;
        if (this.settings.func_186212_b() != m) {
            this.settings.func_186214_a(m);
            this.isDirty = true;
        }
        return this;
    }

    public void reset() {
        this.settings.func_186220_a(Rotation.NONE);
        this.settings.func_186214_a(Mirror.NONE);
        this.offset.func_181079_c(0, 0, 0);
    }

    public int getBlockCount() {
        return this.blockcount;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public int getLayerSize(int layer) {
        if (layer < 0 || layer >= this.layers.size()) {
            return 0;
        }
        return ((List)this.layers.get(layer)).size();
    }

    public IMultiblockBlockReader getMultiblockBlockAccess() {
        return this.blockAccess;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiblockProjection) {
            MultiblockProjection other = (MultiblockProjection)obj;
            return this.multiblock.getUniqueName().equals((Object)other.multiblock.getUniqueName()) && this.settings.func_186212_b() == other.settings.func_186212_b() && this.settings.func_186215_c() == other.settings.func_186215_c();
        }
        return false;
    }

    public boolean process(int layer, Predicate<Info> predicate) {
        this.updateData();
        List blocks = (List)this.layers.get(layer);
        for (Template.BlockInfo info : blocks) {
            BlockPos transformedPos = Template.func_186266_a((PlacementSettings)this.settings, (BlockPos)info.field_186242_a).func_177973_b((Vector3i)this.offset);
            if (!predicate.test(new Info(this.blockAccess, this.settings, info.field_186242_a, transformedPos))) continue;
            return true;
        }
        return false;
    }

    public boolean processAll(BiPredicate<Integer, Info> predicate) {
        this.updateData();
        for (int layer = 0; layer < this.getLayerCount(); ++layer) {
            List blocks = (List)this.layers.get(layer);
            for (Template.BlockInfo info : blocks) {
                BlockPos transformedPos = Template.func_186266_a((PlacementSettings)this.settings, (BlockPos)info.field_186242_a).func_177973_b((Vector3i)this.offset);
                if (!predicate.test(layer, new Info(this.blockAccess, this.settings, info.field_186242_a, transformedPos))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateData() {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        boolean mirrored = this.settings.func_186212_b() == Mirror.FRONT_BACK;
        Rotation rotation = this.settings.func_186215_c();
        Vector3i size = this.multiblock.getSize(this.world);
        if (!mirrored) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    this.offset.func_181079_c(1 - size.func_177952_p(), 0, 0);
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.func_181079_c(1 - size.func_177958_n(), 0, 1 - size.func_177952_p());
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.offset.func_181079_c(0, 0, 1 - size.func_177958_n());
                    break;
                }
                default: {
                    this.offset.func_181079_c(0, 0, 0);
                    break;
                }
            }
        } else {
            switch (rotation) {
                case NONE: {
                    this.offset.func_181079_c(1 - size.func_177958_n(), 0, 0);
                    break;
                }
                case CLOCKWISE_90: {
                    this.offset.func_181079_c(1 - size.func_177952_p(), 0, 1 - size.func_177958_n());
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.func_181079_c(0, 0, 1 - size.func_177952_p());
                    break;
                }
                default: {
                    this.offset.func_181079_c(0, 0, 0);
                }
            }
        }
        int x = (rotation.ordinal() % 2 == 0 ? size.func_177958_n() : size.func_177952_p()) / 2;
        int z = (rotation.ordinal() % 2 == 0 ? size.func_177952_p() : size.func_177958_n()) / 2;
        this.offset.func_239621_a_((Vector3i)this.offset, x, 0, z);
    }

    public static IMultiblockBlockReader getBlockAccessFor(MultiblockHandler.IMultiblock multiblock) {
        return new MultiblockBlockReaderImpl(multiblock);
    }

    static class MultiblockBlockReaderImpl
    implements IMultiblockBlockReader {
        Map<BlockPos, Tuple<BlockState, TileEntity>> map = new HashMap<BlockPos, Tuple<BlockState, TileEntity>>();
        MultiblockHandler.IMultiblock multiblock;

        MultiblockBlockReaderImpl(MultiblockHandler.IMultiblock multiblock) {
            this.multiblock = multiblock;
            List list = multiblock.getStructure(null);
            for (Template.BlockInfo info : list) {
                TileEntity te = null;
                try {
                    TileEntity tmp;
                    if (info.field_186244_c != null && !info.field_186244_c.isEmpty() && (tmp = TileEntity.func_235657_b_((BlockState)info.field_186243_b, (CompoundNBT)info.field_186244_c)) != null) {
                        tmp.field_195045_e = info.field_186243_b;
                        te = tmp;
                    }
                }
                catch (Exception e) {
                    ImmersivePetroleum.log.error((Object)e);
                }
                this.map.put(info.field_186242_a, (Tuple<BlockState, TileEntity>)new Tuple((Object)info.field_186243_b, te));
            }
        }

        public BlockState func_180495_p(BlockPos pos) {
            Tuple<BlockState, TileEntity> tuple = this.map.get(pos);
            if (tuple != null) {
                return (BlockState)tuple.func_76341_a();
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public FluidState func_204610_c(BlockPos pos) {
            return this.func_180495_p(pos).func_204520_s();
        }

        public TileEntity func_175625_s(BlockPos pos) {
            Tuple<BlockState, TileEntity> tuple = this.map.get(pos);
            if (tuple != null) {
                return (TileEntity)tuple.func_76340_b();
            }
            return null;
        }

        public int func_217298_h(BlockPos pos) {
            return 0xF000F0;
        }

        @Override
        public MultiblockHandler.IMultiblock getMultiblock() {
            return this.multiblock;
        }
    }

    public static interface IMultiblockBlockReader
    extends IBlockReader {
        public MultiblockHandler.IMultiblock getMultiblock();
    }

    public static final class Info {
        public final BlockPos templatePos;
        public final BlockPos tPos;
        public final PlacementSettings settings;
        public final MultiblockHandler.IMultiblock multiblock;
        public final IMultiblockBlockReader blockAccess;

        public Info(IMultiblockBlockReader blockAccess, PlacementSettings settings, BlockPos templatePos, BlockPos transformedPos) {
            this.blockAccess = blockAccess;
            this.templatePos = templatePos;
            this.tPos = transformedPos;
            this.settings = settings;
            this.multiblock = blockAccess.getMultiblock();
        }
    }
}

