/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.fluids;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPContent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class IPFluid
extends FlowingFluid {
    public static final List<IPFluid> FLUIDS = new ArrayList<IPFluid>();
    protected final String fluidName;
    protected final ResourceLocation stillTexture;
    protected final ResourceLocation flowingTexture;
    protected IPFluid source;
    protected IPFluid flowing;
    public Block block;
    protected Item bucket;
    @Nullable
    protected final Consumer<FluidAttributes.Builder> buildAttributes;

    public IPFluid(String name, int density, int viscosity) {
        this(name, new ResourceLocation("immersivepetroleum", "block/fluid/" + name + "_still"), new ResourceLocation("immersivepetroleum", "block/fluid/" + name + "_flow"), IPFluid.createBuilder(density, viscosity));
    }

    protected IPFluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
        this(name, stillTexture, flowingTexture, buildAttributes, true);
    }

    protected IPFluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable Consumer<FluidAttributes.Builder> buildAttributes, boolean isSource) {
        this.fluidName = name;
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.buildAttributes = buildAttributes;
        IPContent.registeredIPFluids.add((Fluid)this);
        if (!isSource) {
            this.flowing = this;
            this.setRegistryName("immersivepetroleum", this.fluidName + "_flowing");
        } else {
            this.source = this;
            this.block = this.createFluidBlock();
            this.bucket = this.createBucketItem();
            this.flowing = this.createFlowingFluid();
            this.setRegistryName(new ResourceLocation("immersivepetroleum", this.fluidName));
            FLUIDS.add(this);
            IPContent.registeredIPBlocks.add(this.block);
            IPContent.registeredIPItems.add(this.bucket);
        }
    }

    protected IPFluidFlowing createFlowingFluid() {
        return new IPFluidFlowing(this);
    }

    protected IPFluidBlock createFluidBlock() {
        return new IPFluidBlock(this.source, this.fluidName);
    }

    protected IPBucketItem createBucketItem() {
        return new IPBucketItem(this.source, this.fluidName);
    }

    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)this.stillTexture, (ResourceLocation)this.flowingTexture);
        if (this.buildAttributes != null) {
            this.buildAttributes.accept(builder);
        }
        return builder.build((Fluid)this);
    }

    protected void func_205580_a(IWorld arg0, BlockPos arg1, BlockState arg2) {
    }

    protected boolean func_205579_d() {
        return false;
    }

    public Fluid func_210197_e() {
        return this.flowing;
    }

    public Fluid func_210198_f() {
        return this.source;
    }

    public Item func_204524_b() {
        return this.bucket;
    }

    protected int func_204528_b(IWorldReader arg0) {
        return 1;
    }

    protected int func_185698_b(IWorldReader arg0) {
        return 4;
    }

    protected boolean func_215665_a(FluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !this.func_207187_a(p_215665_4_);
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 5;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    protected BlockState func_204527_a(FluidState state) {
        return (BlockState)this.block.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(IPFluid.func_207205_e((FluidState)state)));
    }

    public boolean func_207193_c(FluidState state) {
        return state.func_206886_c() == this.source;
    }

    public int func_207192_d(FluidState state) {
        return this.func_207193_c(state) ? 8 : (Integer)state.func_177229_b((Property)field_207210_b);
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == this.source || fluidIn == this.flowing;
    }

    public static Consumer<FluidAttributes.Builder> createBuilder(int density, int viscosity) {
        return builder -> builder.viscosity(viscosity).density(density);
    }

    public static class IPFluidFlowing
    extends IPFluid {
        public IPFluidFlowing(IPFluid source) {
            super(source.fluidName, source.stillTexture, source.flowingTexture, source.buildAttributes, false);
            this.source = source;
            this.bucket = source.bucket;
            this.block = source.block;
            this.func_207183_f((FluidState)((FluidState)this.func_207182_e().func_177621_b()).func_206870_a((Property)field_207210_b, (Comparable)Integer.valueOf(7)));
        }

        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }
    }

    public static class IPBucketItem
    extends BucketItem {
        private static final Item.Properties PROPS = new Item.Properties().func_200917_a(1).func_200916_a(ImmersivePetroleum.creativeTab);

        public IPBucketItem(IPFluid fluid, String fluidName) {
            super(() -> fluid, PROPS);
            this.setRegistryName(new ResourceLocation("immersivepetroleum", fluidName + "_bucket"));
        }

        public ItemStack getContainerItem(ItemStack itemStack) {
            return new ItemStack((IItemProvider)Items.field_151133_ar);
        }

        public boolean hasContainerItem(ItemStack stack) {
            return true;
        }

        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
            return new FluidBucketWrapper(stack);
        }
    }

    public static class IPFluidBlock
    extends FlowingFluidBlock {
        private static IPFluid tmp = null;
        private IPFluid fluid;

        public IPFluidBlock(IPFluid fluid, String fluidName) {
            super(IPFluidBlock.supplier(fluid), AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h));
            this.fluid = fluid;
            this.setRegistryName(new ResourceLocation("immersivepetroleum", fluidName + "_fluid_block"));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            IPFluid f = this.fluid != null ? this.fluid : tmp;
            builder.func_206894_a(f.func_207182_e().func_177623_d().toArray(new Property[0]));
        }

        public FluidState func_204507_t(BlockState state) {
            FluidState baseState = super.func_204507_t(state);
            for (Property prop : this.fluid.func_207182_e().func_177623_d()) {
                if (prop == FlowingFluidBlock.field_176367_b) continue;
                baseState = this.withCopiedValue((Property)prop, (StateHolder)baseState, (StateHolder<?, ?>)state);
            }
            return baseState;
        }

        private <T extends StateHolder<?, T>, S extends Comparable<S>> T withCopiedValue(Property<S> prop, T oldState, StateHolder<?, ?> copyFrom) {
            return (T)((StateHolder)oldState.func_206870_a(prop, copyFrom.func_177229_b(prop)));
        }

        private static Supplier<IPFluid> supplier(IPFluid fluid) {
            tmp = fluid;
            return () -> fluid;
        }
    }
}

