/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.PumpjackHandler;
import flaxbeard.immersivepetroleum.common.util.compat.crafttweaker.TweakerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.immersivepetroleum.ReservoirRegistry")
public class ReservoirTweaker {
    @ZenCodeType.Method
    public static boolean remove(String recipeName) {
        List test = PumpjackHandler.reservoirs.keySet().stream().filter(loc -> loc.func_110623_a().contains(recipeName)).collect(Collectors.toList());
        if (test.size() > 1) {
            CraftTweakerAPI.logError((String)"\u00c2\u00a7cMultiple results for \"%s\"\u00c2\u00a7r", (Object[])new Object[]{recipeName});
        } else if (test.size() == 1) {
            ResourceLocation id = (ResourceLocation)test.get(0);
            if (PumpjackHandler.reservoirs.containsKey(id)) {
                PumpjackHandler.reservoirs.remove(id);
                return true;
            }
            CraftTweakerAPI.logError((String)"\u00c2\u00a7c%s does not exist, or was already removed.\u00c2\u00a7r", (Object[])new Object[]{id});
        } else {
            CraftTweakerAPI.logInfo((String)"\"%s\" does not exist or could not be found.", (Object[])new Object[]{recipeName});
        }
        return false;
    }

    @ZenCodeType.Method
    public static void removeAll() {
        PumpjackHandler.reservoirs.clear();
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.immersivepetroleum.ReservoirBuilder")
    public static class ReservoirBuilder {
        private boolean isValid = true;
        private IFluidStack iFluidStack;
        private int minSize;
        private int maxSize;
        private int traceAmount;
        private int weight;
        private List<ResourceLocation> dimWhitelist = new ArrayList<ResourceLocation>();
        private List<ResourceLocation> dimBlacklist = new ArrayList<ResourceLocation>();
        private List<ResourceLocation> bioWhitelist = new ArrayList<ResourceLocation>();
        private List<ResourceLocation> bioBlacklist = new ArrayList<ResourceLocation>();

        @ZenCodeType.Constructor
        public ReservoirBuilder(IFluidStack fluid, int minSize, int maxSize, int traceAmount, int weight) {
            if (fluid == null) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cReservoir fluid can not be null!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            }
            if (minSize <= 0) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cReservoir minSize has to be at least 1mb!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            }
            if (maxSize < minSize) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cReservoir maxSize can not be smaller than minSize!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            }
            if (weight <= 1) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cReservoir weight has to be greater than or equal to 1!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            }
            this.iFluidStack = fluid;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.traceAmount = traceAmount;
            this.weight = weight;
        }

        @ZenCodeType.Method
        public ReservoirBuilder addDimensions(boolean blacklist, String[] names) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            for (int i = 0; i < names.length; ++i) {
                try {
                    list.add(new ResourceLocation(names[i]));
                    continue;
                }
                catch (ResourceLocationException e) {
                    CraftTweakerAPI.logError((String)"\u00c2\u00a7caddDimension: %s\u00c2\u00a7r", (Object[])new Object[]{e.getMessage()});
                }
            }
            if (blacklist) {
                this.dimBlacklist.addAll(list);
            } else {
                this.dimWhitelist.addAll(list);
            }
            return this;
        }

        @ZenCodeType.Method
        public ReservoirBuilder addBiomes(boolean blacklist, String[] names) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            for (int i = 0; i < names.length; ++i) {
                try {
                    list.add(new ResourceLocation(names[i]));
                    continue;
                }
                catch (ResourceLocationException e) {
                    CraftTweakerAPI.logError((String)"\u00c2\u00a7caddBiome: %s\u00c2\u00a7r", (Object[])new Object[]{e.getMessage()});
                }
            }
            if (blacklist) {
                this.bioBlacklist.addAll(list);
            } else {
                this.bioWhitelist.addAll(list);
            }
            return this;
        }

        @ZenCodeType.Method
        public void build(String name) {
            if (name.isEmpty()) {
                CraftTweakerAPI.logError((String)"\u00c2\u00a7cReservoir name can not be empty string!\u00c2\u00a7r", (Object[])new Object[0]);
                this.isValid = false;
            }
            if (this.isValid) {
                ResourceLocation id = TweakerUtils.ctLoc(name);
                if (!PumpjackHandler.reservoirs.containsKey(id)) {
                    PumpjackHandler.ReservoirType type = new PumpjackHandler.ReservoirType(name, id, this.iFluidStack.getFluid().getInternal(), this.minSize, this.maxSize, this.traceAmount, this.weight);
                    if (!this.dimWhitelist.isEmpty()) {
                        type.addDimension(false, this.dimWhitelist);
                    }
                    if (!this.dimBlacklist.isEmpty()) {
                        type.addDimension(true, this.dimBlacklist);
                    }
                    if (!this.bioWhitelist.isEmpty()) {
                        type.addBiome(false, this.bioWhitelist);
                    }
                    if (!this.bioBlacklist.isEmpty()) {
                        type.addBiome(true, this.bioBlacklist);
                    }
                    PumpjackHandler.addReservoir(id, type);
                } else {
                    CraftTweakerAPI.logError((String)"\u00c2\u00a7cReservoir %s already exists!\u00c2\u00a7r", (Object[])new Object[]{name});
                }
            }
        }
    }
}

