/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.entity.SpeedboatEntity;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageConsumeBoatFuel
implements INetMessage {
    public int amount;

    public MessageConsumeBoatFuel(int amount) {
        this.amount = amount;
    }

    public MessageConsumeBoatFuel(PacketBuffer buf) {
        this.amount = buf.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.amount);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity;
            NetworkEvent.Context con = (NetworkEvent.Context)context.get();
            if (con.getDirection().getReceptionSide() == LogicalSide.SERVER && con.getSender() != null && (entity = con.getSender().func_184187_bx()) instanceof SpeedboatEntity) {
                SpeedboatEntity boat = (SpeedboatEntity)entity;
                FluidStack fluid = boat.getContainedFluid();
                if (fluid != null && fluid != FluidStack.EMPTY) {
                    fluid.setAmount(Math.max(0, fluid.getAmount() - this.amount));
                }
                boat.setContainedFluid(fluid);
            }
        });
    }
}

