/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.data;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.client.models.connection.ConnectionLoader;
import blusunrize.immersiveengineering.client.models.split.SplitModelLoader;
import blusunrize.immersiveengineering.common.data.models.LoadedModelBuilder;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.AutoLubricatorBlock;
import flaxbeard.immersivepetroleum.common.blocks.FlarestackBlock;
import flaxbeard.immersivepetroleum.common.blocks.GasGeneratorBlock;
import flaxbeard.immersivepetroleum.common.data.IPLoadedModels;
import flaxbeard.immersivepetroleum.common.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.PumpjackMultiblock;
import flaxbeard.immersivepetroleum.common.util.fluids.IPFluid;
import java.util.Arrays;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class IPBlockStates
extends BlockStateProvider {
    private static final ResourceLocation FORGE_LOADER = new ResourceLocation("forge", "obj");
    final IPLoadedModels loadedModels;
    final ExistingFileHelper exFileHelper;
    private static final Collector<Vector3i, JsonArray, JsonArray> POSITIONS_TO_JSON = Collector.of(JsonArray::new, (arr, vec) -> {
        JsonArray posJson = new JsonArray();
        posJson.add((Number)vec.func_177958_n());
        posJson.add((Number)vec.func_177956_o());
        posJson.add((Number)vec.func_177952_p());
        arr.add((JsonElement)posJson);
    }, (a, b) -> {
        JsonArray arr = new JsonArray();
        arr.addAll(a);
        arr.addAll(b);
        return arr;
    }, new Collector.Characteristics[0]);

    public IPBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper, IPLoadedModels loadedModels) {
        super(gen, "immersivepetroleum", exFileHelper);
        this.loadedModels = loadedModels;
        this.exFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        ModelFile dummyOilOreModel = this.cubeAll(IPContent.Blocks.dummyOilOre);
        this.getVariantBuilder(IPContent.Blocks.dummyOilOre).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(dummyOilOreModel)});
        this.itemModelWithParent(IPContent.Blocks.dummyOilOre, dummyOilOreModel);
        ModelFile.ExistingModelFile dummyPipeModel = new ModelFile.ExistingModelFile(this.modLoc("block/dummy_pipe"), this.exFileHelper);
        this.getVariantBuilder(IPContent.Blocks.dummyPipe).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)dummyPipeModel)});
        this.itemModelWithParent(IPContent.Blocks.dummyPipe, (ModelFile)dummyPipeModel);
        ModelFile.ExistingModelFile dummyConveyorModel = new ModelFile.ExistingModelFile(this.modLoc("block/dummy_conveyor"), this.exFileHelper);
        this.getVariantBuilder(IPContent.Blocks.dummyConveyor).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)dummyConveyorModel)});
        ((ItemModelBuilder)this.getItemBuilder(IPContent.Blocks.dummyConveyor).parent((ModelFile)dummyConveyorModel)).texture("particle", new ResourceLocation("immersiveengineering", "block/conveyor/conveyor"));
        this.distillationtower();
        this.pumpjack();
        this.simpleBlockWithItem(IPContent.Blocks.asphalt);
        this.gasGenerator();
        this.autolubricator();
        this.flarestack();
        for (IPFluid f : IPFluid.FLUIDS) {
            ResourceLocation still = f.getAttributes().getStillTexture();
            ModelBuilder model = this.loadedModels.getBuilder("block/fluid/" + f.getRegistryName().func_110623_a()).texture("particle", still);
            this.getVariantBuilder(f.block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
        this.loadedModels.backupModels();
    }

    private void distillationtower() {
        ResourceLocation idleTexture = this.modLoc("multiblock/distillation_tower");
        ResourceLocation modelNormal = this.modLoc("models/multiblock/obj/distillationtower.obj");
        ResourceLocation modelMirrored = this.modLoc("models/multiblock/obj/distillationtower_mirrored.obj");
        LoadedModelBuilder normal = this.multiblockModel(IPContent.Multiblock.distillationtower, modelNormal, idleTexture, "_idle", (TemplateMultiblock)DistillationTowerMultiblock.INSTANCE, false);
        LoadedModelBuilder mirrored = this.multiblockModel(IPContent.Multiblock.distillationtower, modelMirrored, idleTexture, "_mirrored_idle", (TemplateMultiblock)DistillationTowerMultiblock.INSTANCE, true);
        this.createMultiblock(IPContent.Multiblock.distillationtower, (ModelFile)normal, (ModelFile)mirrored, idleTexture);
    }

    private void pumpjack() {
        ResourceLocation texture = this.modLoc("multiblock/pumpjack_base");
        ResourceLocation modelNormal = this.modLoc("models/multiblock/obj/pumpjack.obj");
        ResourceLocation modelMirrored = this.modLoc("models/multiblock/obj/pumpjack_mirrored.obj");
        LoadedModelBuilder normal = this.multiblockModel(IPContent.Multiblock.pumpjack, modelNormal, texture, "", (TemplateMultiblock)PumpjackMultiblock.INSTANCE, false);
        LoadedModelBuilder mirrored = this.multiblockModel(IPContent.Multiblock.pumpjack, modelMirrored, texture, "_mirrored", (TemplateMultiblock)PumpjackMultiblock.INSTANCE, true);
        this.createMultiblock(IPContent.Multiblock.pumpjack, (ModelFile)normal, (ModelFile)mirrored, texture);
    }

    private LoadedModelBuilder multiblockModel(Block block, ResourceLocation model, ResourceLocation texture, String add, TemplateMultiblock mb, boolean mirror) {
        UnaryOperator transform = UnaryOperator.identity();
        if (mirror) {
            Vector3i size = mb.getSize(null);
            transform = p -> new BlockPos(size.func_177958_n() - p.func_177958_n() - 1, p.func_177956_o(), p.func_177952_p());
        }
        BlockPos offset = mb.getMasterFromOriginOffset();
        Stream<Vector3i> partsStream = mb.getStructure(null).stream().filter(info -> !info.field_186243_b.func_196958_f()).map(info -> info.field_186242_a).map(transform).map(arg_0 -> IPBlockStates.lambda$multiblockModel$3((Vector3i)offset, arg_0));
        LoadedModelBuilder out = ((LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.withExistingParent(this.getMultiblockPath(block) + add, this.mcLoc("block")).texture("texture", texture)).texture("particle", texture)).additional("flip-v", true).additional("model", model).additional("detectCullableFaces", false).additional("base_loader", FORGE_LOADER).additional("dynamic", false).loader(SplitModelLoader.LOCATION);
        JsonArray partsJson = partsStream.collect(POSITIONS_TO_JSON);
        out.additional("split_parts", (JsonElement)partsJson);
        return out;
    }

    private void autolubricator() {
        ResourceLocation texture = this.modLoc("models/lubricator");
        LoadedModelBuilder lube_empty = (LoadedModelBuilder)this.loadedModels.withExistingParent("lube_empty", new ResourceLocation("immersiveengineering", "block/ie_empty")).texture("particle", texture);
        LoadedModelBuilder lubeModel = (LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.withExistingParent(this.getPath(IPContent.Blocks.auto_lubricator), this.mcLoc("block")).loader(FORGE_LOADER).additional("model", this.modLoc("models/block/obj/autolubricator.obj")).additional("flip-v", true).texture("texture", texture)).texture("particle", texture);
        VariantBlockStateBuilder lubeBuilder = this.getVariantBuilder(IPContent.Blocks.auto_lubricator);
        for (Direction dir : AutoLubricatorBlock.FACING.func_177700_c()) {
            int rot = 90 * dir.func_176736_b() + 90;
            lubeBuilder.partialState().with((Property)AutoLubricatorBlock.SLAVE, (Comparable)Boolean.valueOf(false)).with((Property)AutoLubricatorBlock.FACING, (Comparable)dir).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)lubeModel, 0, rot, false)});
            lubeBuilder.partialState().with((Property)AutoLubricatorBlock.SLAVE, (Comparable)Boolean.valueOf(true)).with((Property)AutoLubricatorBlock.FACING, (Comparable)dir).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)lube_empty)});
        }
    }

    private void flarestack() {
        ResourceLocation texture = this.modLoc("block/obj/flarestack");
        ConfiguredModel emptyModel = new ConfiguredModel((ModelFile)this.loadedModels.withExistingParent("flare_empty", new ResourceLocation("immersiveengineering", "block/ie_empty")).texture("particle", texture));
        LoadedModelBuilder flarestackModel = (LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.withExistingParent(this.getPath(IPContent.Blocks.flarestack), this.mcLoc("block")).loader(FORGE_LOADER).additional("model", this.modLoc("models/block/obj/flarestack.obj")).additional("flip-v", true).texture("texture", texture)).texture("particle", texture);
        VariantBlockStateBuilder flarestackBuilder = this.getVariantBuilder(IPContent.Blocks.flarestack);
        flarestackBuilder.partialState().with((Property)FlarestackBlock.SLAVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)flarestackModel, 0, 0, false)});
        flarestackBuilder.partialState().with((Property)FlarestackBlock.SLAVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{emptyModel});
    }

    private void gasGenerator() {
        JsonObject basemodel = new JsonObject();
        basemodel.addProperty("loader", "forge:obj");
        basemodel.addProperty("model", this.modLoc("models/block/obj/generator.obj").toString());
        basemodel.addProperty("flip-v", Boolean.valueOf(true));
        ResourceLocation texture = this.modLoc("block/obj/generator");
        LoadedModelBuilder model = ((LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.getBuilder(this.getPath(IPContent.Blocks.gas_generator)).texture("texture", texture)).texture("particle", texture)).loader(ConnectionLoader.LOADER_NAME).additional("base_model", (JsonElement)basemodel).additional("layers", Arrays.asList("solid", "cutout"));
        VariantBlockStateBuilder builder = this.getVariantBuilder(IPContent.Blocks.gas_generator);
        Direction.Plane.HORIZONTAL.forEach(dir -> {
            int rotation = (90 * dir.func_176736_b() + 90) % 360;
            builder.partialState().with((Property)GasGeneratorBlock.FACING, (Comparable)dir).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, rotation, false)});
        });
    }

    private void createMultiblock(Block b, ModelFile masterModel, ModelFile mirroredModel, ResourceLocation particleTexture) {
        this.createMultiblock(b, masterModel, mirroredModel, (Property<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (Property<Boolean>)IEProperties.MIRRORED, 180, particleTexture);
    }

    private void createMultiblock(Block b, ModelFile masterModel, @Nullable ModelFile mirroredModel, Property<Boolean> isSlave, EnumProperty<Direction> facing, @Nullable Property<Boolean> mirroredState, int rotationOffset, ResourceLocation particleTex) {
        Preconditions.checkArgument((mirroredModel == null == (mirroredState == null) ? 1 : 0) != 0);
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        boolean[] possibleMirrorStates = mirroredState != null ? new boolean[]{false, true} : new boolean[1];
        for (boolean mirrored : possibleMirrorStates) {
            for (Direction dir : facing.func_177700_c()) {
                int angleY;
                int angleX;
                if (facing.func_177700_c().contains(Direction.UP)) {
                    angleX = -90 * dir.func_96559_d();
                    angleY = dir.func_176740_k() != Direction.Axis.Y ? this.getAngle(dir, rotationOffset) : 0;
                } else {
                    angleY = this.getAngle(dir, rotationOffset);
                    angleX = 0;
                }
                ModelFile model = mirrored ? mirroredModel : masterModel;
                VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(facing, (Comparable)dir);
                if (mirroredState != null) {
                    partialState = partialState.with(mirroredState, (Comparable)Boolean.valueOf(mirrored));
                }
                partialState.setModels(new ConfiguredModel[]{new ConfiguredModel(model, angleX, angleY, true)});
            }
        }
    }

    private int getAngle(Direction dir, int offset) {
        return (int)((dir.func_185119_l() + (float)offset) % 360.0f);
    }

    private String getMultiblockPath(Block b) {
        return "multiblock/" + this.getPath(b);
    }

    private String getPath(Block b) {
        return b.getRegistryName().func_110623_a();
    }

    private void itemModelWithParent(Block block, ModelFile parent) {
        ((ItemModelBuilder)this.getItemBuilder(block).parent(parent)).texture("particle", this.modLoc("block/" + this.getPath(block)));
    }

    private void simpleBlockWithItem(Block block) {
        ModelFile file = this.cubeAll(block);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(file)});
        this.itemModelWithParent(block, file);
    }

    private ItemModelBuilder getItemBuilder(Block block) {
        return (ItemModelBuilder)this.itemModels().getBuilder(this.modLoc("item/" + this.getPath(block)).toString());
    }

    private static /* synthetic */ Vector3i lambda$multiblockModel$3(Vector3i offset, BlockPos p) {
        return p.func_177973_b(offset);
    }
}

