/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class AutoLubricatorTileEntity
extends TileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.ITileDrop {
    public static TileEntityType<AutoLubricatorTileEntity> TYPE;
    public boolean isSlave;
    public boolean isActive;
    public boolean predictablyDraining = false;
    public Direction facing;
    public FluidTank tank = new FluidTank(8000, fluid -> fluid != null && LubricantHandler.isValidLube(fluid.getFluid()));
    private LazyOptional<IFluidHandler> outputHandler;
    int count = 0;
    int lastTank = 0;
    int lastTankUpdate = 0;
    int countClient = 0;

    public AutoLubricatorTileEntity() {
        this(TYPE);
    }

    public AutoLubricatorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.isSlave = compound.func_74767_n("slave");
        this.isActive = compound.func_74767_n("active");
        this.predictablyDraining = compound.func_74767_n("predictablyDraining");
        Direction facing = Direction.func_176739_a((String)compound.func_74779_i("facing"));
        if (facing.func_176736_b() == -1) {
            facing = Direction.NORTH;
        }
        this.facing = facing;
        this.tank.readFromNBT(compound.func_74775_l("tank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("slave", this.isSlave);
        compound.func_74757_a("active", this.isActive);
        compound.func_74757_a("predictablyDraining", this.predictablyDraining);
        compound.func_74778_a("facing", this.facing.func_176742_j());
        compound.func_74768_a("count", this.count);
        CompoundNBT tank = this.tank.writeToNBT(new CompoundNBT());
        compound.func_218657_a("tank", (INBT)tank);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void readTank(CompoundNBT nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void writeTank(CompoundNBT nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        if (!toItem || write) {
            nbt.func_218657_a("tank", (INBT)tankTag);
        }
    }

    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readTank(stack.func_77978_p());
        }
    }

    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = new ItemStack((IItemProvider)((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c());
        CompoundNBT tag = new CompoundNBT();
        this.writeTank(tag, true);
        if (!tag.isEmpty()) {
            stack.func_77982_d(tag);
        }
        return Arrays.asList(stack);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.isSlave && (side == null || side == Direction.UP)) {
            if (this.outputHandler == null) {
                this.outputHandler = LazyOptional.of(() -> {
                    TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(Direction.DOWN));
                    if (te != null && te instanceof AutoLubricatorTileEntity) {
                        return ((AutoLubricatorTileEntity)te).tank;
                    }
                    return null;
                });
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.outputHandler != null) {
            this.outputHandler.invalidate();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.outputHandler != null) {
            this.outputHandler.invalidate();
        }
    }

    public Direction getFacing() {
        return this.facing;
    }

    public boolean isMaster() {
        return !this.isSlave;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos pos = this.func_174877_v();
        int size = 3;
        return new AxisAlignedBB((double)(pos.func_177958_n() - size), (double)(pos.func_177956_o() - size), (double)(pos.func_177952_p() - size), (double)(pos.func_177958_n() + size), (double)(pos.func_177956_o() + size), (double)(pos.func_177952_p() + size));
    }

    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        TileEntity master;
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(Hand.MAIN_HAND)) && (master = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, this.isSlave ? -1 : 0, 0))) != null && master instanceof AutoLubricatorTileEntity) {
            AutoLubricatorTileEntity lube = (AutoLubricatorTileEntity)master;
            Object s = null;
            s = !lube.tank.isEmpty() ? ((IFormattableTextComponent)lube.tank.getFluid().getDisplayName()).func_240702_b_(": " + lube.tank.getFluidAmount() + "mB") : new TranslationTextComponent("gui.immersiveengineering.empty");
            return new ITextComponent[]{s};
        }
        return null;
    }

    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        AutoLubricatorTileEntity master;
        AutoLubricatorTileEntity autoLubricatorTileEntity = master = this.isSlave ? this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -1, 0)) : this;
        if (master != null && master instanceof AutoLubricatorTileEntity) {
            if (!this.func_145831_w().field_72995_K && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)master.tank)) {
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 1024.0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isSlave) {
            EventHandler.REMOVE_FROM_TICKING.add(this);
            return;
        }
        if (this.isMaster()) {
            TileEntity master;
            BlockPos target;
            TileEntity te;
            LubricatedHandler.ILubricationHandler<TileEntity> handler;
            if (this.tank.getFluid() != null && this.tank.getFluid() != FluidStack.EMPTY && this.tank.getFluidAmount() >= LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid()) && LubricantHandler.isValidLube(this.tank.getFluid().getFluid()) && (handler = LubricatedHandler.getHandlerForTile(te = this.field_145850_b.func_175625_s(target = this.field_174879_c.func_177972_a(this.facing)))) != null && (master = handler.isPlacedCorrectly(this.field_145850_b, this, this.facing)) != null && handler.isMachineEnabled(this.field_145850_b, master)) {
                ++this.count;
                handler.lubricate(this.field_145850_b, this.count, master);
                if (!this.field_145850_b.field_72995_K && this.count % 4 == 0) {
                    this.tank.drain(LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid()), IFluidHandler.FluidAction.EXECUTE);
                    this.func_70296_d();
                }
                ++this.countClient;
                if (this.countClient % 50 == 0) {
                    this.countClient = this.field_145850_b.field_73012_v.nextInt(40);
                    handler.spawnLubricantParticles(this.field_145850_b, this, this.facing, master);
                }
            }
            if (!this.field_145850_b.field_72995_K && this.lastTank != this.tank.getFluidAmount()) {
                if (this.predictablyDraining && !this.tank.isEmpty() && this.lastTank - this.tank.getFluidAmount() == LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid())) {
                    this.lastTank = this.tank.getFluidAmount();
                }
                if (Math.abs(this.lastTankUpdate - this.tank.getFluidAmount()) > 25) {
                    this.predictablyDraining = !this.tank.isEmpty() && this.lastTank - this.tank.getFluidAmount() == LubricantHandler.getLubeAmount(this.tank.getFluid().getFluid());
                    this.lastTankUpdate = this.tank.getFluidAmount();
                }
                this.func_70296_d();
            }
        }
    }
}

