/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.FlarestackTileEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class FlarestackBlock
extends IPBlockBase {
    private static final Material material = new Material(MaterialColor.field_151668_h, false, false, true, true, false, false, PushReaction.BLOCK);
    public static final BooleanProperty SLAVE = BooleanProperty.func_177716_a((String)"slave");
    static VoxelShape SHAPE_SLAVE;
    static VoxelShape SHAPE_MASTER;

    public FlarestackBlock() {
        super("flarestack", AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(3.0f, 15.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockItem createBlockItem() {
        return new FlarestackBlockItem(this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SLAVE});
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (((Boolean)state.func_177229_b((Property)SLAVE)).booleanValue()) {
            worldIn.func_175655_b(pos.func_177982_a(0, -1, 0), true);
        } else {
            worldIn.func_175655_b(pos.func_177982_a(0, 1, 0), false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175656_a(pos.func_177972_a(Direction.UP), (BlockState)state.func_206870_a((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (((Boolean)state.func_177229_b((Property)SLAVE)).booleanValue() && !entityIn.func_230279_az_()) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (!((Boolean)state.func_177229_b((Property)SLAVE)).booleanValue()) {
            return Arrays.asList(new ItemStack((IItemProvider)this, 1));
        }
        return Collections.emptyList();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)SLAVE)).booleanValue()) {
            if (SHAPE_SLAVE == null) {
                VoxelShape s0 = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.75, (double)0.875);
                VoxelShape s1 = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375);
                SHAPE_SLAVE = VoxelShapes.func_197878_a((VoxelShape)s0, (VoxelShape)s1, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            return SHAPE_SLAVE;
        }
        if (SHAPE_MASTER == null) {
            VoxelShape s0 = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.75, (double)0.875);
            VoxelShape s1 = VoxelShapes.func_197873_a((double)0.0625, (double)0.5, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
            SHAPE_MASTER = VoxelShapes.func_197878_a((VoxelShape)s0, (VoxelShape)s1, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return SHAPE_MASTER;
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((Property)SLAVE) == false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return FlarestackTileEntity.TYPE.func_200968_a();
    }

    public static class FlarestackBlockItem
    extends IPBlockItemBase {
        public FlarestackBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties().func_200916_a(ImmersivePetroleum.creativeTab));
        }

        protected boolean func_195944_a(BlockItemUseContext con, BlockState state) {
            if (super.func_195944_a(con, state)) {
                BlockPos otherPos = con.func_195995_a().func_177972_a(Direction.UP);
                BlockState otherState = con.func_195991_k().func_180495_p(otherPos);
                return otherState.func_177230_c().isAir(otherState, (IBlockReader)con.func_195991_k(), otherPos);
            }
            return false;
        }
    }
}

