/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.CrusherTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ExcavatorTileEntity;
import blusunrize.immersiveengineering.common.util.IEPotions;
import flaxbeard.immersivepetroleum.api.IPTags;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.IPConfig;
import flaxbeard.immersivepetroleum.common.blocks.AsphaltBlock;
import flaxbeard.immersivepetroleum.common.blocks.AutoLubricatorBlock;
import flaxbeard.immersivepetroleum.common.blocks.BlockDummy;
import flaxbeard.immersivepetroleum.common.blocks.DistillationTowerBlock;
import flaxbeard.immersivepetroleum.common.blocks.FlarestackBlock;
import flaxbeard.immersivepetroleum.common.blocks.GasGeneratorBlock;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.PumpjackBlock;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DistillationTowerTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.FlarestackTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.GasGeneratorTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.entity.SpeedboatEntity;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.items.IPUpgradeItem;
import flaxbeard.immersivepetroleum.common.items.OilCanItem;
import flaxbeard.immersivepetroleum.common.items.ProjectorItem;
import flaxbeard.immersivepetroleum.common.items.SpeedboatItem;
import flaxbeard.immersivepetroleum.common.lubehandlers.CrusherLubricationHandler;
import flaxbeard.immersivepetroleum.common.lubehandlers.ExcavatorLubricationHandler;
import flaxbeard.immersivepetroleum.common.lubehandlers.PumpjackLubricationHandler;
import flaxbeard.immersivepetroleum.common.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.PumpjackMultiblock;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import flaxbeard.immersivepetroleum.common.util.fluids.IPFluid;
import flaxbeard.immersivepetroleum.common.util.fluids.NapalmFluid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="immersivepetroleum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPContent {
    public static final Logger log = LogManager.getLogger((String)"immersivepetroleum/Content");
    public static final List<Block> registeredIPBlocks = new ArrayList<Block>();
    public static final List<Item> registeredIPItems = new ArrayList<Item>();
    public static final List<Fluid> registeredIPFluids = new ArrayList<Fluid>();
    public static DebugItem debugItem;

    public static void populate() {
        debugItem = new DebugItem();
        Fluids.crudeOil = new IPFluid("oil", 1000, 2250);
        Fluids.diesel = new IPFluid("diesel", 789, 1750);
        Fluids.lubricant = new IPFluid("lubricant", 925, 1000);
        Fluids.gasoline = new IPFluid("gasoline", 789, 1200);
        Fluids.napalm = new NapalmFluid();
        Blocks.dummyOilOre = new BlockDummy("dummy_oil_ore");
        Blocks.dummyPipe = new BlockDummy("dummy_pipe");
        Blocks.dummyConveyor = new BlockDummy("dummy_conveyor");
        Multiblock.distillationtower = new DistillationTowerBlock();
        Multiblock.pumpjack = new PumpjackBlock();
        Blocks.asphalt = new AsphaltBlock();
        Blocks.gas_generator = new GasGeneratorBlock();
        Blocks.auto_lubricator = new AutoLubricatorBlock("auto_lubricator");
        Blocks.flarestack = new FlarestackBlock();
        Items.bitumen = new IPItemBase("bitumen");
        Items.oil_can = new OilCanItem("oil_can");
        Items.speedboat = new SpeedboatItem("speedboat");
        BoatUpgrades.reinforced_hull = new IPUpgradeItem("reinforced_hull", "BOAT");
        BoatUpgrades.ice_breaker = new IPUpgradeItem("icebreaker", "BOAT");
        BoatUpgrades.tank = new IPUpgradeItem("tank", "BOAT");
        BoatUpgrades.rudders = new IPUpgradeItem("rudders", "BOAT");
        BoatUpgrades.paddles = new IPUpgradeItem("paddles", "BOAT");
        Items.projector = new ProjectorItem("projector");
    }

    public static void preInit() {
    }

    public static void init() {
        ChemthrowerHandler.registerEffect(IPTags.Fluids.lubricant, (ChemthrowerHandler.ChemthrowerEffect)new LubricatedHandler.LubricantEffect());
        ChemthrowerHandler.registerEffect(IPTags.Fluids.lubricant, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.slippery, 60, 1));
        ChemthrowerHandler.registerEffect((ITag)IETags.fluidPlantoil, (ChemthrowerHandler.ChemthrowerEffect)new LubricatedHandler.LubricantEffect());
        ChemthrowerHandler.registerEffect(IPTags.Fluids.gasoline, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.flammable, 60, 1));
        ChemthrowerHandler.registerFlammable(IPTags.Fluids.gasoline);
        ChemthrowerHandler.registerEffect(IPTags.Fluids.napalm, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.flammable, 60, 2));
        ChemthrowerHandler.registerFlammable(IPTags.Fluids.napalm);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)DistillationTowerMultiblock.INSTANCE);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)PumpjackMultiblock.INSTANCE);
        IPConfig.Utils.addFuel((List)IPConfig.GENERATION.fuels.get());
        IPConfig.Utils.addBoatFuel((List)IPConfig.MISCELLANEOUS.boat_fuels.get());
        DieselHandler.registerFuel(IPTags.Fluids.diesel, (int)150);
        LubricantHandler.registerLubricant((Fluid)Fluids.lubricant, 3);
        LubricantHandler.registerLubricant((Fluid)IEContent.fluidPlantoil, 12);
        LubricatedHandler.registerLubricatedTile(PumpjackTileEntity.class, PumpjackLubricationHandler::new);
        LubricatedHandler.registerLubricatedTile(ExcavatorTileEntity.class, ExcavatorLubricationHandler::new);
        LubricatedHandler.registerLubricatedTile(CrusherTileEntity.class, CrusherLubricationHandler::new);
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        IPContent.registerTile(event, DistillationTowerTileEntity.class, Multiblock.distillationtower);
        IPContent.registerTile(event, PumpjackTileEntity.class, Multiblock.pumpjack);
        IPContent.registerTile(event, AutoLubricatorTileEntity.class, Blocks.auto_lubricator);
        IPContent.registerTile(event, FlarestackTileEntity.class, Blocks.flarestack);
        IPContent.registerTile(event, GasGeneratorTileEntity.class, Blocks.gas_generator);
    }

    public static <T extends TileEntity> void registerTile(RegistryEvent.Register<TileEntityType<?>> event, Class<T> tile, Block ... valid) {
        String s = tile.getSimpleName();
        s = s.substring(0, s.indexOf("TileEntity")).toLowerCase(Locale.ENGLISH);
        TileEntityType<T> type = IPContent.createType(tile, valid);
        type.setRegistryName("immersivepetroleum", s);
        event.getRegistry().register(type);
        try {
            tile.getField("TYPE").set(null, type);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        log.debug("Registered TileEntity: {} as {}", tile, (Object)type.getRegistryName());
    }

    private static <T extends TileEntity> TileEntityType<T> createType(Class<T> typeClass, Block ... valid) {
        HashSet<Block> validSet = new HashSet<Block>(Arrays.asList(valid));
        TileEntityType type = new TileEntityType(() -> {
            try {
                return (TileEntity)typeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }, validSet, null);
        return type;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : registeredIPBlocks) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
            catch (Throwable e) {
                log.error("Failed to register a block. ({})", (Object)block);
                throw e;
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : registeredIPItems) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
            catch (Throwable e) {
                log.error("Failed to register an item. ({}, {})", (Object)item, (Object)item.getRegistryName());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public static void registerFluids(RegistryEvent.Register<Fluid> event) {
        for (Fluid fluid : registeredIPFluids) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)fluid);
            }
            catch (Throwable e) {
                log.error("Failed to register a fluid. ({}, {})", (Object)fluid, (Object)fluid.getRegistryName());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        try {
            event.getRegistry().register(SpeedboatEntity.TYPE);
        }
        catch (Throwable e) {
            log.error("Failed to register Speedboat Entity. {}", (Object)e.getMessage());
            throw e;
        }
    }

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<Effect> event) {
        IPEffects.init();
    }

    public static class BoatUpgrades {
        public static IPUpgradeItem reinforced_hull;
        public static IPUpgradeItem ice_breaker;
        public static IPUpgradeItem tank;
        public static IPUpgradeItem rudders;
        public static IPUpgradeItem paddles;
    }

    public static class Items {
        public static IPItemBase bitumen;
        public static IPItemBase projector;
        public static IPItemBase speedboat;
        public static IPItemBase oil_can;
    }

    public static class Blocks {
        public static IPBlockBase asphalt;
        public static IPBlockBase gas_generator;
        public static IPBlockBase auto_lubricator;
        public static IPBlockBase flarestack;
        public static BlockDummy dummyOilOre;
        public static BlockDummy dummyPipe;
        public static BlockDummy dummyConveyor;
    }

    public static class Fluids {
        public static IPFluid crudeOil;
        public static IPFluid diesel;
        public static IPFluid lubricant;
        public static IPFluid gasoline;
        public static IPFluid napalm;
    }

    public static class Multiblock {
        public static Block distillationtower;
        public static Block pumpjack;
    }
}

