/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.worldgen.IFeature;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class OreFeature<T extends IPlacementConfig>
extends ConfigBase
implements IFeature {
    public String id;
    protected ConfigBase.ConfigBool enable;
    protected ConfigBase.ConfigInt clusterSize;
    protected ConfigBase.ConfigInt minHeight;
    protected ConfigBase.ConfigInt maxHeight;
    private NonNullSupplier<? extends Block> block;
    private Biome.Category specificCategory;

    public OreFeature(NonNullSupplier<? extends Block> block, int clusterSize) {
        this.block = block;
        this.enable = this.b(true, "enable", "Whether to spawn this in your World");
        this.clusterSize = this.i(clusterSize, 0, "clusterSize", new String[0]);
        this.minHeight = this.i(0, 0, "minHeight", new String[0]);
        this.maxHeight = this.i(256, 0, "maxHeight", new String[0]);
    }

    public OreFeature<T> between(int minHeight, int maxHeight) {
        this.allValues.remove(this.minHeight);
        this.allValues.remove(this.maxHeight);
        this.minHeight = this.i(minHeight, 0, "minHeight", new String[0]);
        this.maxHeight = this.i(maxHeight, 0, "maxHeight", new String[0]);
        return this;
    }

    public OreFeature<T> inBiomes(Biome.Category category) {
        this.specificCategory = category;
        return this;
    }

    @Override
    public void onReload() {
    }

    @Override
    public Optional<ConfiguredFeature<?, ?>> createFeature(BiomeLoadingEvent biome) {
        if (this.specificCategory != null && biome.getCategory() != this.specificCategory) {
            return Optional.empty();
        }
        if (!this.canGenerate()) {
            return Optional.empty();
        }
        Pair<Placement<T>, T> placement = this.getPlacement();
        ConfiguredFeature createdFeature = (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, this.block.get().func_176223_P(), ((Integer)this.clusterSize.get()).intValue())).func_227228_a_(((Placement)placement.getKey()).func_227446_a_((IPlacementConfig)placement.getValue())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(((Integer)this.minHeight.get()).intValue(), 0, (Integer)this.maxHeight.get() - (Integer)this.minHeight.get()))).func_242728_a();
        return Optional.of(createdFeature);
    }

    @Override
    public GenerationStage.Decoration getGenerationStage() {
        return GenerationStage.Decoration.UNDERGROUND_ORES;
    }

    protected boolean canGenerate() {
        return (Integer)this.minHeight.get() < (Integer)this.maxHeight.get() && (Integer)this.clusterSize.get() > 0 && (Boolean)this.enable.get() != false && (Boolean)AllConfigs.COMMON.worldGen.disable.get() == false;
    }

    protected abstract Pair<Placement<T>, T> getPlacement();

    @Override
    public void addToConfig(ForgeConfigSpec.Builder builder) {
        this.registerAll(builder);
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

