/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.palettes.AllPaletteBlocks;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.worldgen.ChanceOreFeature;
import com.simibubi.create.foundation.worldgen.CountedOreFeature;
import com.simibubi.create.foundation.worldgen.IFeature;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public enum AllWorldFeatures {
    COPPER_ORE(new CountedOreFeature(AllBlocks.COPPER_ORE, 18, 2).between(40, 86)),
    COPPER_ORE_OCEAN(new CountedOreFeature(AllBlocks.COPPER_ORE, 15, 4).between(20, 55).inBiomes(Biome.Category.OCEAN)),
    ZINC_ORE(new CountedOreFeature(AllBlocks.ZINC_ORE, 14, 4).between(15, 70)),
    ZINC_ORE_DESERT(new CountedOreFeature(AllBlocks.ZINC_ORE, 17, 5).between(10, 85).inBiomes(Biome.Category.DESERT)),
    LIMESTONE(new ChanceOreFeature(AllPaletteBlocks.LIMESTONE, 128, 0.03125f).between(30, 70)),
    WEATHERED_LIMESTONE(new ChanceOreFeature(AllPaletteBlocks.WEATHERED_LIMESTONE, 128, 0.03125f).between(10, 30)),
    DOLOMITE(new ChanceOreFeature(AllPaletteBlocks.DOLOMITE, 128, 0.015625f).between(20, 70)),
    GABBRO(new ChanceOreFeature(AllPaletteBlocks.GABBRO, 128, 0.015625f).between(20, 70)),
    SCORIA(new ChanceOreFeature(AllPaletteBlocks.NATURAL_SCORIA, 128, 0.03125f).between(0, 10));

    public static final int forcedUpdateVersion = 1;
    public IFeature feature;

    private AllWorldFeatures(IFeature feature) {
        this.feature = feature;
        this.feature.setId(Lang.asId(this.name()));
    }

    public static void reload(BiomeLoadingEvent event) {
        for (AllWorldFeatures entry : AllWorldFeatures.values()) {
            Optional<ConfiguredFeature<?, ?>> createFeature;
            if (event.getName() == Biomes.field_185440_P.getRegistryName() || event.getCategory() == Biome.Category.NETHER || !(createFeature = entry.feature.createFeature(event)).isPresent()) continue;
            event.getGeneration().func_242513_a(entry.feature.getGenerationStage(), createFeature.get());
        }
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder) {
        Arrays.stream(AllWorldFeatures.values()).forEach(entry -> {
            builder.push(Lang.asId(entry.name()));
            entry.feature.addToConfig(builder);
            builder.pop();
        });
    }
}

