/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement.util;

import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
public abstract class PoleHelper<T extends Comparable<T>>
implements IPlacementHelper {
    protected final Predicate<BlockState> statePredicate;
    protected final Property<T> property;
    protected final Function<BlockState, Direction.Axis> axisFunction;

    public PoleHelper(Predicate<BlockState> statePredicate, Function<BlockState, Direction.Axis> axisFunction, Property<T> property) {
        this.statePredicate = statePredicate;
        this.axisFunction = axisFunction;
        this.property = property;
    }

    public boolean matchesAxis(BlockState state, Direction.Axis axis) {
        if (!this.statePredicate.test(state)) {
            return false;
        }
        return this.axisFunction.apply(state) == axis;
    }

    public int attachedPoles(World world, BlockPos pos, Direction direction) {
        BlockPos checkPos = pos.func_177972_a(direction);
        BlockState state = world.func_180495_p(checkPos);
        int count = 0;
        while (this.matchesAxis(state, direction.func_176740_k())) {
            ++count;
            checkPos = checkPos.func_177972_a(direction);
            state = world.func_180495_p(checkPos);
        }
        return count;
    }

    @Override
    public Predicate<BlockState> getStatePredicate() {
        return this.statePredicate;
    }

    @Override
    public PlacementOffset getOffset(World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
        List<Direction> directions = IPlacementHelper.orderedByDistance(pos, ray.func_216347_e(), dir -> dir.func_176740_k() == this.axisFunction.apply(state));
        for (Direction dir2 : directions) {
            int poles;
            BlockPos newPos = pos.func_177967_a(dir2, (poles = this.attachedPoles(world, pos, dir2)) + 1);
            BlockState newState = world.func_180495_p(newPos);
            if (!newState.func_185904_a().func_76222_j()) continue;
            return PlacementOffset.success((Vector3i)newPos, bState -> (BlockState)bState.func_206870_a(this.property, state.func_177229_b(this.property)));
        }
        return PlacementOffset.fail();
    }

    @Override
    public void renderAt(BlockPos pos, BlockState state, BlockRayTraceResult ray, PlacementOffset offset) {
        Vector3d centerOffset = Vector3d.func_237491_b_((Vector3i)ray.func_216354_b().func_176730_m()).func_186678_a(0.3);
        IPlacementHelper.renderArrow(VecHelper.getCenterOf((Vector3i)pos).func_178787_e(centerOffset), VecHelper.getCenterOf(offset.getPos()).func_178787_e(centerOffset), ray.func_216354_b(), 0.75);
    }
}

