/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlacementHelpers {
    private static final List<IPlacementHelper> helpers = new ArrayList<IPlacementHelper>();

    public static int register(IPlacementHelper helper) {
        helpers.add(helper);
        return helpers.size() - 1;
    }

    public static IPlacementHelper get(int id) {
        if (id < 0 || id >= helpers.size()) {
            throw new ArrayIndexOutOfBoundsException("id " + id + " for placement helper not known");
        }
        return helpers.get(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        if (!(mc.field_71476_x instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult ray = (BlockRayTraceResult)mc.field_71476_x;
        if (mc.field_71439_g == null) {
            return;
        }
        List filteredForHeldItem = helpers.stream().filter(helper -> Arrays.stream(Hand.values()).anyMatch(hand -> helper.getItemPredicate().test(mc.field_71439_g.func_184586_b(hand)))).collect(Collectors.toList());
        if (filteredForHeldItem.isEmpty()) {
            return;
        }
        if (mc.field_71439_g.func_225608_bj_()) {
            return;
        }
        BlockPos pos = ray.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        List filteredForState = filteredForHeldItem.stream().filter(helper -> helper.getStatePredicate().test(state)).collect(Collectors.toList());
        if (filteredForState.isEmpty()) {
            return;
        }
        for (IPlacementHelper h : filteredForState) {
            PlacementOffset offset = h.getOffset((World)world, state, pos, ray);
            if (!offset.isSuccessful()) continue;
            h.renderAt(pos, state, ray, offset);
            break;
        }
    }
}

