/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.renderState.RenderTypes;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Vector3d;

public abstract class Outline {
    protected OutlineParams params = new OutlineParams();
    protected Matrix3f transformNormals;

    public abstract void render(MatrixStack var1, SuperRenderTypeBuffer var2);

    public void renderCuboidLine(MatrixStack ms, SuperRenderTypeBuffer buffer, Vector3d start, Vector3d end) {
        Vector3d diff = end.func_178788_d(start);
        float hAngle = AngleHelper.deg(MathHelper.func_181159_b((double)diff.field_72450_a, (double)diff.field_72449_c));
        float hDistance = (float)diff.func_216372_d(1.0, 0.0, 1.0).func_72433_c();
        float vAngle = AngleHelper.deg(MathHelper.func_181159_b((double)hDistance, (double)diff.field_72448_b)) - 90.0f;
        ms.func_227860_a_();
        MatrixStacker.of(ms).translate(start).rotateY(hAngle).rotateX(vAngle);
        this.renderAACuboidLine(ms, buffer, Vector3d.field_186680_a, new Vector3d(0.0, 0.0, diff.func_72433_c()));
        ms.func_227865_b_();
    }

    public void renderAACuboidLine(MatrixStack ms, SuperRenderTypeBuffer buffer, Vector3d start, Vector3d end) {
        float lineWidth = this.params.getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        IVertexBuilder builder = buffer.getBuffer(RenderTypes.getOutlineSolid());
        Vector3d diff = end.func_178788_d(start);
        if (diff.field_72450_a + diff.field_72448_b + diff.field_72449_c < 0.0) {
            Vector3d temp = start;
            start = end;
            end = temp;
            diff = diff.func_186678_a(-1.0);
        }
        Vector3d extension = diff.func_72432_b().func_186678_a((double)(lineWidth / 2.0f));
        Vector3d plane = VecHelper.axisAlingedPlaneOf(diff);
        Direction face = Direction.func_210769_a((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c);
        Direction.Axis axis = face.func_176740_k();
        start = start.func_178788_d(extension);
        end = end.func_178787_e(extension);
        plane = plane.func_186678_a((double)(lineWidth / 2.0f));
        Vector3d a1 = plane.func_178787_e(start);
        Vector3d b1 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a2 = plane.func_178787_e(start);
        Vector3d b2 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a3 = plane.func_178787_e(start);
        Vector3d b3 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vector3d a4 = plane.func_178787_e(start);
        Vector3d b4 = plane.func_178787_e(end);
        if (this.params.disableNormals) {
            face = Direction.UP;
            this.putQuad(ms, builder, b4, b3, b2, b1, face);
            this.putQuad(ms, builder, a1, a2, a3, a4, face);
            this.putQuad(ms, builder, a1, b1, b2, a2, face);
            this.putQuad(ms, builder, a2, b2, b3, a3, face);
            this.putQuad(ms, builder, a3, b3, b4, a4, face);
            this.putQuad(ms, builder, a4, b4, b1, a1, face);
            return;
        }
        this.putQuad(ms, builder, b4, b3, b2, b1, face);
        this.putQuad(ms, builder, a1, a2, a3, a4, face.func_176734_d());
        Vector3d vec = a1.func_178788_d(a4);
        face = Direction.func_210769_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
        this.putQuad(ms, builder, a1, b1, b2, a2, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = Direction.func_210769_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
        this.putQuad(ms, builder, a2, b2, b3, a3, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = Direction.func_210769_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
        this.putQuad(ms, builder, a3, b3, b4, a4, face);
        vec = VecHelper.rotate(vec, -90.0, axis);
        face = Direction.func_210769_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
        this.putQuad(ms, builder, a4, b4, b1, a1, face);
    }

    public void putQuad(MatrixStack ms, IVertexBuilder builder, Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, Direction normal) {
        this.putQuadUV(ms, builder, v1, v2, v3, v4, 0.0f, 0.0f, 1.0f, 1.0f, normal);
    }

    public void putQuadUV(MatrixStack ms, IVertexBuilder builder, Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, float minU, float minV, float maxU, float maxV, Direction normal) {
        this.putVertex(ms, builder, v1, minU, minV, normal);
        this.putVertex(ms, builder, v2, maxU, minV, normal);
        this.putVertex(ms, builder, v3, maxU, maxV, normal);
        this.putVertex(ms, builder, v4, minU, maxV, normal);
    }

    protected void putVertex(MatrixStack ms, IVertexBuilder builder, Vector3d pos, float u, float v, Direction normal) {
        int i = 0xF000F0;
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        MatrixStack.Entry peek = ms.func_227866_c_();
        Vector3d rgb = this.params.rgb;
        if (this.transformNormals == null) {
            this.transformNormals = peek.func_227872_b_();
        }
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        if (normal != null) {
            xOffset = normal.func_82601_c();
            yOffset = normal.func_96559_d();
            zOffset = normal.func_82599_e();
        }
        builder.func_227888_a_(peek.func_227870_a_(), (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c).func_227885_a_((float)rgb.field_72450_a, (float)rgb.field_72448_b, (float)rgb.field_72449_c, this.params.alpha).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_225587_b_(j, k).func_227887_a_(peek.func_227872_b_(), (float)xOffset, (float)yOffset, (float)zOffset).func_181675_d();
        this.transformNormals = null;
    }

    public void tick() {
    }

    public OutlineParams getParams() {
        return this.params;
    }

    public static class OutlineParams {
        protected Optional<AllSpecialTextures> faceTexture;
        protected Optional<AllSpecialTextures> hightlightedFaceTexture = Optional.empty();
        protected Direction highlightedFace;
        protected boolean fadeLineWidth = true;
        protected boolean disableCull;
        protected boolean disableNormals;
        protected float alpha = 1.0f;
        protected int lightMapU;
        protected int lightMapV;
        protected Vector3d rgb;
        private float lineWidth = 0.03125f;

        public OutlineParams() {
            this.faceTexture = this.hightlightedFaceTexture;
            this.rgb = ColorHelper.getRGB(0xFFFFFF);
            int i = 0xF000F0;
            this.lightMapU = i >> 16 & 0xFFFF;
            this.lightMapV = i & 0xFFFF;
        }

        public OutlineParams colored(int color) {
            this.rgb = ColorHelper.getRGB(color);
            return this;
        }

        public OutlineParams lineWidth(float width) {
            this.lineWidth = width;
            return this;
        }

        public OutlineParams withFaceTexture(AllSpecialTextures texture) {
            this.faceTexture = Optional.ofNullable(texture);
            return this;
        }

        public OutlineParams clearTextures() {
            return this.withFaceTextures(null, null);
        }

        public OutlineParams withFaceTextures(AllSpecialTextures texture, AllSpecialTextures highlightTexture) {
            this.faceTexture = Optional.ofNullable(texture);
            this.hightlightedFaceTexture = Optional.ofNullable(highlightTexture);
            return this;
        }

        public OutlineParams highlightFace(@Nullable Direction face) {
            this.highlightedFace = face;
            return this;
        }

        public OutlineParams disableNormals() {
            this.disableNormals = true;
            return this;
        }

        public OutlineParams disableCull() {
            this.disableCull = true;
            return this;
        }

        public float getLineWidth() {
            return this.fadeLineWidth ? this.alpha * this.lineWidth : this.lineWidth;
        }

        public Direction getHighlightedFace() {
            return this.highlightedFace;
        }
    }
}

