/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.VirtualEmptyModelData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class SuperByteBufferCache {
    public static final Compartment<BlockState> GENERIC_TILE = new Compartment();
    public static final Compartment<AllBlockPartials> PARTIAL = new Compartment();
    public static final Compartment<Pair<Direction, AllBlockPartials>> DIRECTIONAL_PARTIAL = new Compartment();
    Map<Compartment<?>, Cache<Object, SuperByteBuffer>> cache = new HashMap();

    public SuperByteBufferCache() {
        this.registerCompartment(GENERIC_TILE);
        this.registerCompartment(PARTIAL);
        this.registerCompartment(DIRECTIONAL_PARTIAL);
    }

    public SuperByteBuffer renderBlock(BlockState toRender) {
        return this.getGeneric(toRender, () -> this.standardBlockRender(toRender));
    }

    public SuperByteBuffer renderPartial(AllBlockPartials partial, BlockState referenceState) {
        return this.get(PARTIAL, partial, () -> this.standardModelRender(partial.get(), referenceState));
    }

    public SuperByteBuffer renderPartial(AllBlockPartials partial, BlockState referenceState, MatrixStack modelTransform) {
        return this.get(PARTIAL, partial, () -> this.standardModelRender(partial.get(), referenceState, modelTransform));
    }

    public SuperByteBuffer renderDirectionalPartial(AllBlockPartials partial, BlockState referenceState, Direction dir) {
        return this.get(DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> this.standardModelRender(partial.get(), referenceState));
    }

    public SuperByteBuffer renderDirectionalPartial(AllBlockPartials partial, BlockState referenceState, Direction dir, MatrixStack modelTransform) {
        return this.get(DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> this.standardModelRender(partial.get(), referenceState, modelTransform));
    }

    public SuperByteBuffer renderBlockIn(Compartment<BlockState> compartment, BlockState toRender) {
        return this.get(compartment, toRender, () -> this.standardBlockRender(toRender));
    }

    SuperByteBuffer getGeneric(BlockState key, Supplier<SuperByteBuffer> supplier) {
        return this.get(GENERIC_TILE, key, supplier);
    }

    public <T> SuperByteBuffer get(Compartment<T> compartment, T key, Supplier<SuperByteBuffer> supplier) {
        Cache<Object, SuperByteBuffer> compartmentCache = this.cache.get(compartment);
        try {
            return (SuperByteBuffer)compartmentCache.get(key, supplier::get);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void registerCompartment(Compartment<?> instance) {
        this.cache.put(instance, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().build());
    }

    public void registerCompartment(Compartment<?> instance, long ticksUntilExpired) {
        this.cache.put(instance, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().expireAfterAccess(ticksUntilExpired * 50L, TimeUnit.MILLISECONDS).build());
    }

    private SuperByteBuffer standardBlockRender(BlockState renderedState) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        return this.standardModelRender(dispatcher.func_184389_a(renderedState), renderedState);
    }

    private SuperByteBuffer standardModelRender(IBakedModel model, BlockState referenceState) {
        return this.standardModelRender(model, referenceState, new MatrixStack());
    }

    private SuperByteBuffer standardModelRender(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        BufferBuilder builder = new BufferBuilder(512);
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        blockRenderer.renderModel((IBlockDisplayReader)mc.field_71441_e, model, referenceState, BlockPos.field_177992_a.func_177981_b(255), ms, (IVertexBuilder)builder, true, mc.field_71441_e.field_73012_v, 42L, OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
        builder.func_178977_d();
        return new SuperByteBuffer(builder);
    }

    public void invalidate() {
        this.cache.forEach((comp, cache) -> cache.invalidateAll());
    }

    public static class Compartment<T> {
    }
}

