/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;

public class BlockHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static void addReducedDestroyEffects(BlockState state, World worldIn, BlockPos pos, ParticleManager manager) {
        if (!(worldIn instanceof ClientWorld)) {
            return;
        }
        ClientWorld world = (ClientWorld)worldIn;
        VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, pos);
        MutableInt amtBoxes = new MutableInt(0);
        voxelshape.func_197755_b((x1, y1, z1, x2, y2, z2) -> amtBoxes.increment());
        double chance = 1.0 / (double)amtBoxes.getValue().intValue();
        voxelshape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            double d1 = Math.min(1.0, x2 - x1);
            double d2 = Math.min(1.0, y2 - y1);
            double d3 = Math.min(1.0, z2 - z1);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        if (world.field_73012_v.nextDouble() > chance) continue;
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + x1;
                        double d8 = d5 * d2 + y1;
                        double d9 = d6 * d3 + z1;
                        manager.func_78873_a((Particle)new DiggingParticle(world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                    }
                }
            }
        });
    }

    public static BlockState setZeroAge(BlockState blockState) {
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_222512_Y)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_222512_Y, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208167_T)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208167_T, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208168_U)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208168_U, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208169_V)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208169_V, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208170_W)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208171_X)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208172_Y)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208172_Y, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_227036_ao_)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208128_ac)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208128_ac, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208137_al)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208137_al, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208130_ae)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208130_ae, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_222509_am)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_222509_am, (Comparable)Integer.valueOf(0));
        }
        if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208181_h)) {
            return (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208181_h, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    public static int findAndRemoveInInventory(BlockState block, PlayerEntity player, int amount) {
        int taken;
        boolean needsTwo;
        int amountFound = 0;
        Item required = BlockHelper.getRequiredItem(block).func_77973_b();
        boolean bl = needsTwo = BlockHelper.hasBlockStateProperty(block, BlockStateProperties.field_208145_at) && block.func_177229_b((Property)BlockStateProperties.field_208145_at) == SlabType.DOUBLE;
        if (needsTwo) {
            amount *= 2;
        }
        if (BlockHelper.hasBlockStateProperty(block, BlockStateProperties.field_208127_ab)) {
            amount *= ((Integer)block.func_177229_b((Property)BlockStateProperties.field_208127_ab)).intValue();
        }
        if (BlockHelper.hasBlockStateProperty(block, BlockStateProperties.field_208135_aj)) {
            amount *= ((Integer)block.func_177229_b((Property)BlockStateProperties.field_208135_aj)).intValue();
        }
        int preferredSlot = player.field_71071_by.field_70461_c;
        ItemStack itemstack = player.field_71071_by.func_70301_a(preferredSlot);
        int count = itemstack.func_190916_E();
        if (itemstack.func_77973_b() == required && count > 0) {
            taken = Math.min(count, amount - amountFound);
            player.field_71071_by.func_70299_a(preferredSlot, new ItemStack((IItemProvider)itemstack.func_77973_b(), count - taken));
            amountFound += taken;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && amountFound != amount; ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            count = itemstack.func_190916_E();
            if (itemstack.func_77973_b() != required || count <= 0) continue;
            taken = Math.min(count, amount - amountFound);
            player.field_71071_by.func_70299_a(i, new ItemStack((IItemProvider)itemstack.func_77973_b(), count - taken));
            amountFound += taken;
        }
        if (needsTwo) {
            if (amountFound % 2 != 0) {
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)required));
            }
            amountFound /= 2;
        }
        return amountFound;
    }

    public static ItemStack getRequiredItem(BlockState state) {
        ItemStack itemStack = new ItemStack((IItemProvider)state.func_177230_c());
        if (itemStack.func_77973_b() == Items.field_221736_cd) {
            itemStack = new ItemStack((IItemProvider)Items.field_221582_j);
        } else if (itemStack.func_77973_b() == Items.field_221906_fk) {
            itemStack = new ItemStack((IItemProvider)Items.field_221581_i);
        }
        return itemStack;
    }

    public static void destroyBlock(World world, BlockPos pos, float effectChance) {
        BlockHelper.destroyBlock(world, pos, effectChance, stack -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack));
    }

    public static void destroyBlock(World world, BlockPos pos, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        TileEntity tileentity;
        FluidState FluidState2 = world.func_204610_c(pos);
        BlockState state = world.func_180495_p(pos);
        if (world.field_73012_v.nextFloat() < effectChance) {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
        TileEntity tileEntity = tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
        if (world.func_82736_K().func_223586_b(GameRules.field_223603_f) && !world.restoringBlockSnapshots && world instanceof ServerWorld) {
            for (ItemStack itemStack : Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)tileentity)) {
                droppedItemCallback.accept(itemStack);
            }
            state.func_215706_a((ServerWorld)world, pos, ItemStack.field_190927_a);
        }
        world.func_175656_a(pos, FluidState2.func_206883_i());
    }

    public static boolean isSolidWall(IBlockReader reader, BlockPos fromPos, Direction toDirection) {
        return BlockHelper.hasBlockSolidSide(reader.func_180495_p(fromPos.func_177972_a(toDirection)), reader, fromPos.func_177972_a(toDirection), toDirection.func_176734_d());
    }

    public static boolean noCollisionInSpace(IBlockReader reader, BlockPos pos) {
        return reader.func_180495_p(pos).func_196952_d(reader, pos).func_197766_b();
    }

    public static boolean hasBlockStateProperty(BlockState state, Property<?> p) {
        return state.func_235903_d_(p).isPresent();
    }

    public static boolean hasBlockSolidSide(BlockState p_220056_0_, IBlockReader p_220056_1_, BlockPos p_220056_2_, Direction p_220056_3_) {
        return !p_220056_0_.func_235714_a_((ITag)BlockTags.field_206952_E) && Block.func_208061_a((VoxelShape)p_220056_0_.func_196952_d(p_220056_1_, p_220056_2_), (Direction)p_220056_3_);
    }

    public static boolean extinguishFire(World world, @Nullable PlayerEntity p_175719_1_, BlockPos p_175719_2_, Direction p_175719_3_) {
        if (world.func_180495_p(p_175719_2_ = p_175719_2_.func_177972_a(p_175719_3_)).func_177230_c() == Blocks.field_150480_ab) {
            world.func_217378_a(p_175719_1_, 1009, p_175719_2_, 0);
            world.func_217377_a(p_175719_2_, false);
            return true;
        }
        return false;
    }
}

