/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.belt;

import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DirectBeltInputBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<DirectBeltInputBehaviour> TYPE = new BehaviourType();
    private InsertionCallback tryInsert = this::defaultInsertionCallback;
    private AvailabilityPredicate canInsert = d -> true;
    private Supplier<Boolean> supportsBeltFunnels = () -> false;

    public DirectBeltInputBehaviour(SmartTileEntity te) {
        super(te);
    }

    public DirectBeltInputBehaviour allowingBeltFunnelsWhen(Supplier<Boolean> pred) {
        this.supportsBeltFunnels = pred;
        return this;
    }

    public DirectBeltInputBehaviour allowingBeltFunnels() {
        this.supportsBeltFunnels = () -> true;
        return this;
    }

    public DirectBeltInputBehaviour onlyInsertWhen(AvailabilityPredicate pred) {
        this.canInsert = pred;
        return this;
    }

    public DirectBeltInputBehaviour setInsertionHandler(InsertionCallback callback) {
        this.tryInsert = callback;
        return this;
    }

    private ItemStack defaultInsertionCallback(TransportedItemStack inserted, Direction side, boolean simulate) {
        LazyOptional lazy = this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (!lazy.isPresent()) {
            return inserted.stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)lazy.orElse(null)), (ItemStack)inserted.stack.func_77946_l(), (boolean)simulate);
    }

    public boolean canInsertFromSide(Direction side) {
        return this.canInsert.test(side);
    }

    public ItemStack handleInsertion(ItemStack stack, Direction side, boolean simulate) {
        return this.handleInsertion(new TransportedItemStack(stack), side, simulate);
    }

    public ItemStack handleInsertion(TransportedItemStack stack, Direction side, boolean simulate) {
        return this.tryInsert.apply(stack, side, simulate);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public ItemStack tryExportingToBeltFunnel(ItemStack stack, @Nullable Direction side) {
        BlockPos funnelPos = this.tileEntity.func_174877_v().func_177984_a();
        World world = this.getWorld();
        BlockState funnelState = world.func_180495_p(funnelPos);
        if (!(funnelState.func_177230_c() instanceof BeltFunnelBlock)) {
            return stack;
        }
        if (funnelState.func_177229_b(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.PULLING) {
            return stack;
        }
        if (side != null && FunnelBlock.getFunnelFacing(funnelState) != side) {
            return stack;
        }
        TileEntity te = world.func_175625_s(funnelPos);
        if (!(te instanceof FunnelTileEntity)) {
            return stack;
        }
        ItemStack insert = FunnelBlock.tryInsert(world, funnelPos, stack, false);
        if (insert.func_190916_E() != stack.func_190916_E()) {
            ((FunnelTileEntity)te).flap(true);
        }
        return insert;
    }

    public boolean canSupportBeltFunnels() {
        return this.supportsBeltFunnels.get();
    }

    @FunctionalInterface
    public static interface AvailabilityPredicate {
        public boolean test(Direction var1);
    }

    @FunctionalInterface
    public static interface InsertionCallback {
        public ItemStack apply(TransportedItemStack var1, Direction var2, boolean var3);
    }
}

