/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ValueBoxTransform {
    protected float scale = this.getScale();

    protected abstract Vector3d getLocalOffset(BlockState var1);

    protected abstract void rotate(BlockState var1, MatrixStack var2);

    public boolean testHit(BlockState state, Vector3d localHit) {
        Vector3d offset = this.getLocalOffset(state);
        if (offset == null) {
            return false;
        }
        return localHit.func_72438_d(offset) < (double)(this.scale / 2.0f);
    }

    public void transform(BlockState state, MatrixStack ms) {
        Vector3d position = this.getLocalOffset(state);
        if (position == null) {
            return;
        }
        ms.func_227861_a_(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        this.rotate(state, ms);
        ms.func_227862_a_(this.scale, this.scale, this.scale);
    }

    public boolean shouldRender(BlockState state) {
        return state.func_185904_a() != Material.field_151579_a && this.getLocalOffset(state) != null;
    }

    protected Vector3d rotateHorizontally(BlockState state, Vector3d vec) {
        float yRot = 0.0f;
        if (BlockHelper.hasBlockStateProperty(state, BlockStateProperties.field_208155_H)) {
            yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H));
        }
        if (BlockHelper.hasBlockStateProperty(state, BlockStateProperties.field_208157_J)) {
            yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J));
        }
        return VecHelper.rotateCentered(vec, yRot, Direction.Axis.Y);
    }

    protected float getScale() {
        return 0.4f;
    }

    protected float getFontScale() {
        return 0.015625f;
    }

    public static abstract class Sided
    extends ValueBoxTransform {
        protected Direction direction = Direction.UP;

        public Sided fromSide(Direction direction) {
            this.direction = direction;
            return this;
        }

        @Override
        protected Vector3d getLocalOffset(BlockState state) {
            Vector3d location = this.getSouthLocation();
            location = VecHelper.rotateCentered(location, AngleHelper.horizontalAngle(this.getSide()), Direction.Axis.Y);
            location = VecHelper.rotateCentered(location, AngleHelper.verticalAngle(this.getSide()), Direction.Axis.Z);
            return location;
        }

        protected abstract Vector3d getSouthLocation();

        @Override
        protected void rotate(BlockState state, MatrixStack ms) {
            float yRot = AngleHelper.horizontalAngle(this.getSide()) + 180.0f;
            float xRot = this.getSide() == Direction.UP ? 90.0f : (this.getSide() == Direction.DOWN ? 270.0f : 0.0f);
            MatrixStacker.of(ms).rotateY(yRot).rotateX(xRot);
        }

        @Override
        public boolean shouldRender(BlockState state) {
            return super.shouldRender(state) && this.isSideActive(state, this.getSide());
        }

        @Override
        public boolean testHit(BlockState state, Vector3d localHit) {
            return this.isSideActive(state, this.getSide()) && super.testHit(state, localHit);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return true;
        }

        public Direction getSide() {
            return this.direction;
        }
    }

    public static abstract class Dual
    extends ValueBoxTransform {
        protected boolean first;

        public Dual(boolean first) {
            this.first = first;
        }

        public boolean isFirst() {
            return this.first;
        }

        public static Pair<ValueBoxTransform, ValueBoxTransform> makeSlots(Function<Boolean, ? extends Dual> factory) {
            return Pair.of((Object)factory.apply(true), (Object)factory.apply(false));
        }

        @Override
        public boolean testHit(BlockState state, Vector3d localHit) {
            Vector3d offset = this.getLocalOffset(state);
            if (offset == null) {
                return false;
            }
            return localHit.func_72438_d(offset) < (double)(this.scale / 3.5f);
        }
    }
}

