/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.VirtualEmptyModelData;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class GuiGameElement {
    public static GuiRenderBuilder of(ItemStack stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(IItemProvider itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(BlockState state) {
        return new GuiBlockStateRenderBuilder(state);
    }

    public static GuiRenderBuilder of(AllBlockPartials partial) {
        return new GuiBlockPartialRenderBuilder(partial);
    }

    public static GuiRenderBuilder of(Fluid fluid) {
        return new GuiBlockStateRenderBuilder((BlockState)fluid.func_207188_f().func_206883_i().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(0)));
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private final ItemStack stack;

        public GuiItemRenderBuilder(ItemStack stack) {
            this.stack = stack;
        }

        public GuiItemRenderBuilder(IItemProvider provider) {
            this(new ItemStack(provider));
        }

        @Override
        public void render(MatrixStack matrixStack) {
            this.prepareMatrix(matrixStack);
            this.transformMatrix(matrixStack);
            GuiItemRenderBuilder.renderItemIntoGUI(matrixStack, this.stack);
            this.cleanUpMatrix(matrixStack);
        }

        public static void renderItemIntoGUI(MatrixStack matrixStack, ItemStack stack) {
            boolean flag;
            ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel bakedModel = renderer.func_184393_a(stack, null, null);
            matrixStack.func_227860_a_();
            renderer.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
            renderer.field_175057_n.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227861_a_(0.0, 0.0, (double)(100.0f + renderer.field_77023_b));
            matrixStack.func_227861_a_(8.0, 8.0, 0.0);
            matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
            IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            boolean bl = flag = !bakedModel.func_230044_c_();
            if (flag) {
                RenderHelper.func_227783_c_();
            }
            renderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedModel);
            irendertypebuffer$impl.func_228461_a_();
            RenderSystem.enableDepthTest();
            if (flag) {
                RenderHelper.func_227784_d_();
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            RenderSystem.enableCull();
            matrixStack.func_227865_b_();
        }
    }

    public static class GuiBlockPartialRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockPartialRenderBuilder(AllBlockPartials partial) {
            super(partial.get(), null);
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockStateRenderBuilder(BlockState blockstate) {
            super(Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockstate), blockstate);
        }

        @Override
        protected void renderModel(BlockRendererDispatcher blockRenderer, IRenderTypeBuffer.Impl buffer, RenderType renderType, IVertexBuilder vb, MatrixStack ms) {
            if (this.blockState.func_177230_c() instanceof FireBlock) {
                RenderHelper.func_227783_c_();
                blockRenderer.renderBlock(this.blockState, ms, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
                RenderHelper.func_227780_a_();
                buffer.func_228461_a_();
                return;
            }
            super.renderModel(blockRenderer, buffer, renderType, vb, ms);
            if (this.blockState.func_204520_s().func_206888_e()) {
                return;
            }
            RenderSystem.pushMatrix();
            RenderHelper.func_74518_a();
            FluidRenderer.renderTiledFluidBB(new FluidStack(this.blockState.func_204520_s().func_206886_c(), 1000), 0.0f, 0.0f, 0.0f, 1.0001f, 1.0001f, 1.0001f, (IRenderTypeBuffer)buffer, ms, 0xF000F0, true);
            buffer.func_228462_a_(RenderType.func_228645_f_());
            RenderHelper.func_227780_a_();
            RenderSystem.popMatrix();
        }
    }

    private static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected IBakedModel blockmodel;
        protected BlockState blockState;

        public GuiBlockModelRenderBuilder(IBakedModel blockmodel, @Nullable BlockState blockState) {
            this.blockState = blockState == null ? Blocks.field_150350_a.func_176223_P() : blockState;
            this.blockmodel = blockmodel;
        }

        @Override
        public void render(MatrixStack matrixStack) {
            this.prepareMatrix(matrixStack);
            Minecraft mc = Minecraft.func_71410_x();
            BlockRendererDispatcher blockRenderer = mc.func_175602_ab();
            IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
            RenderType renderType = this.blockState.func_177230_c() == Blocks.field_150350_a ? Atlases.func_228785_j_() : RenderTypeLookup.func_239220_a_((BlockState)this.blockState, (boolean)true);
            IVertexBuilder vb = buffer.getBuffer(renderType);
            this.transformMatrix(matrixStack);
            mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            this.renderModel(blockRenderer, buffer, renderType, vb, matrixStack);
            this.cleanUpMatrix(matrixStack);
        }

        protected void renderModel(BlockRendererDispatcher blockRenderer, IRenderTypeBuffer.Impl buffer, RenderType renderType, IVertexBuilder vb, MatrixStack ms) {
            int color = Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.blockState, null, null, 0);
            Vector3d rgb = ColorHelper.getRGB(color == -1 ? this.color : color);
            blockRenderer.func_175019_b().renderModel(ms.func_227866_c_(), vb, this.blockState, this.blockmodel, (float)rgb.field_72450_a, (float)rgb.field_72448_b, (float)rgb.field_72449_c, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
            buffer.func_228461_a_();
        }
    }

    public static abstract class GuiRenderBuilder {
        double xBeforeScale;
        double yBeforeScale;
        double zBeforeScale = 0.0;
        double x;
        double y;
        double z;
        double xRot;
        double yRot;
        double zRot;
        double scale = 1.0;
        int color = 0xFFFFFF;
        Vector3d rotationOffset = Vector3d.field_186680_a;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public GuiRenderBuilder at(double x, double y) {
            this.xBeforeScale = x;
            this.yBeforeScale = y;
            return this;
        }

        public GuiRenderBuilder at(double x, double y, double z) {
            this.xBeforeScale = x;
            this.yBeforeScale = y;
            this.zBeforeScale = z;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(Vector3d offset) {
            this.rotationOffset = offset;
            return this;
        }

        public abstract void render(MatrixStack var1);

        @Deprecated
        protected void prepare() {
        }

        protected void prepareMatrix(MatrixStack matrixStack) {
            matrixStack.func_227860_a_();
            RenderSystem.enableBlend();
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderHelper.func_227784_d_();
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Deprecated
        protected void transform() {
            RenderSystem.translated((double)this.xBeforeScale, (double)this.yBeforeScale, (double)0.0);
            RenderSystem.scaled((double)this.scale, (double)this.scale, (double)this.scale);
            RenderSystem.translated((double)this.x, (double)this.y, (double)this.z);
            RenderSystem.scaled((double)1.0, (double)-1.0, (double)1.0);
            RenderSystem.translated((double)this.rotationOffset.field_72450_a, (double)this.rotationOffset.field_72448_b, (double)this.rotationOffset.field_72449_c);
            RenderSystem.rotatef((float)((float)this.zRot), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.rotatef((float)((float)this.xRot), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)((float)this.yRot), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.translated((double)(-this.rotationOffset.field_72450_a), (double)(-this.rotationOffset.field_72448_b), (double)(-this.rotationOffset.field_72449_c));
        }

        protected void transformMatrix(MatrixStack matrixStack) {
            matrixStack.func_227861_a_(this.xBeforeScale, this.yBeforeScale, this.zBeforeScale);
            matrixStack.func_227862_a_((float)this.scale, (float)this.scale, (float)this.scale);
            matrixStack.func_227861_a_(this.x, this.y, this.z);
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            matrixStack.func_227861_a_(this.rotationOffset.field_72450_a, this.rotationOffset.field_72448_b, this.rotationOffset.field_72449_c);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)this.zRot));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)this.xRot));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)this.yRot));
            matrixStack.func_227861_a_(-this.rotationOffset.field_72450_a, -this.rotationOffset.field_72448_b, -this.rotationOffset.field_72449_c);
        }

        @Deprecated
        protected void cleanUp() {
        }

        protected void cleanUpMatrix(MatrixStack matrixStack) {
            matrixStack.func_227865_b_();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
        }
    }
}

