/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.Create;
import com.simibubi.create.content.palettes.ConnectedGlassBlock;
import com.simibubi.create.content.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.palettes.GlassPaneBlock;
import com.simibubi.create.content.palettes.WindowBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.GlassPaneCTBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.WoodType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;

public class WindowGen {
    private static final CreateRegistrate REGISTRATE = Create.registrate();

    public static BlockEntry<WindowBlock> woodenWindowBlock(WoodType woodType, Block planksBlock) {
        return WindowGen.woodenWindowBlock(woodType, planksBlock, () -> RenderType::func_228641_d_);
    }

    public static BlockEntry<WindowBlock> customWindowBlock(String name, Supplier<? extends IItemProvider> ingredient, CTSpriteShiftEntry ct, Supplier<Supplier<RenderType>> renderType) {
        NonNullFunction<String, ResourceLocation> end_texture = n -> Create.asResource(WindowGen.palettesDir() + name + "_end");
        NonNullFunction<String, ResourceLocation> side_texture = n -> Create.asResource(WindowGen.palettesDir() + n);
        return WindowGen.windowBlock(name, ingredient, ct, renderType, end_texture, side_texture);
    }

    public static BlockEntry<WindowBlock> woodenWindowBlock(WoodType woodType, Block planksBlock, Supplier<Supplier<RenderType>> renderType) {
        String woodName = woodType.func_227048_b_();
        String name = woodName + "_window";
        NonNullFunction<String, ResourceLocation> end_texture = $ -> new ResourceLocation("block/" + woodName + "_planks");
        NonNullFunction<String, ResourceLocation> side_texture = n -> Create.asResource(WindowGen.palettesDir() + n);
        return WindowGen.windowBlock(name, () -> planksBlock, AllSpriteShifts.getWoodenWindow(woodType), renderType, end_texture, side_texture);
    }

    public static BlockEntry<WindowBlock> windowBlock(String name, Supplier<? extends IItemProvider> ingredient, CTSpriteShiftEntry ct, Supplier<Supplier<RenderType>> renderType, NonNullFunction<String, ResourceLocation> endTexture, NonNullFunction<String, ResourceLocation> sideTexture) {
        return ((BlockBuilder)REGISTRATE.block(name, WindowBlock::new).onRegister(CreateRegistrate.connectedTextures(new HorizontalCTBehaviour(ct)))).addLayer(renderType).recipe((c, p) -> ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)c.get()), (int)2).func_200472_a(" # ").func_200472_a("#X#").func_200462_a(Character.valueOf('#'), (IItemProvider)ingredient.get()).func_200471_a(Character.valueOf('X'), (Ingredient)DataIngredient.tag((ITag.INamedTag<Item>)Tags.Items.GLASS_COLORLESS)).func_200465_a("has_ingredient", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)ingredient.get())).func_200464_a(p::accept)).initialProperties(() -> Blocks.field_150359_w).loot((t, g) -> t.func_218466_b((Block)g)).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeColumn(c.getName(), (ResourceLocation)sideTexture.apply(c.getName()), (ResourceLocation)endTexture.apply(c.getName())))).tag(BlockTags.field_211923_H).simpleItem().register();
    }

    public static BlockEntry<ConnectedGlassBlock> framedGlass(String name, ConnectedTextureBehaviour behaviour) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name, ConnectedGlassBlock::new).onRegister(CreateRegistrate.connectedTextures(behaviour))).addLayer(() -> RenderType::func_228645_f_).initialProperties(() -> Blocks.field_150359_w).loot((t, g) -> t.func_218466_b((Block)g)).recipe((c, p) -> p.stonecutting(DataIngredient.tag((ITag.INamedTag<Item>)Tags.Items.GLASS_COLORLESS), c::get)).blockstate((c, p) -> BlockStateGen.cubeAll(c, p, "palettes/", "framed_glass")).tag(new ITag.INamedTag[]{Tags.Blocks.GLASS_COLORLESS, BlockTags.field_211923_H}).item().tag(new ITag.INamedTag[]{Tags.Items.GLASS_COLORLESS}).model((c, p) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)p.cubeColumn(c.getName(), p.modLoc(WindowGen.palettesDir() + c.getName()), p.modLoc("block/palettes/framed_glass"));
        }).build()).register();
    }

    public static BlockEntry<ConnectedGlassPaneBlock> framedGlassPane(String name, Supplier<? extends Block> parent, CTSpriteShiftEntry ctshift) {
        ResourceLocation sideTexture = Create.asResource(WindowGen.palettesDir() + "framed_glass");
        ResourceLocation itemSideTexture = Create.asResource(WindowGen.palettesDir() + name);
        ResourceLocation topTexture = Create.asResource(WindowGen.palettesDir() + "framed_glass_pane_top");
        Supplier<Supplier<RenderType>> renderType = () -> RenderType::func_228645_f_;
        return WindowGen.connectedGlassPane(name, parent, ctshift, sideTexture, itemSideTexture, topTexture, renderType);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> customWindowPane(String name, Supplier<? extends Block> parent, CTSpriteShiftEntry ctshift, Supplier<Supplier<RenderType>> renderType) {
        ResourceLocation topTexture = Create.asResource(WindowGen.palettesDir() + name + "_pane_top");
        ResourceLocation sideTexture = Create.asResource(WindowGen.palettesDir() + name);
        return WindowGen.connectedGlassPane(name, parent, ctshift, sideTexture, sideTexture, topTexture, renderType);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> woodenWindowPane(WoodType woodType, Supplier<? extends Block> parent) {
        return WindowGen.woodenWindowPane(woodType, parent, () -> RenderType::func_228641_d_);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> woodenWindowPane(WoodType woodType, Supplier<? extends Block> parent, Supplier<Supplier<RenderType>> renderType) {
        String woodName = woodType.func_227048_b_();
        String name = woodName + "_window";
        ResourceLocation topTexture = new ResourceLocation("block/" + woodName + "_planks");
        ResourceLocation sideTexture = Create.asResource(WindowGen.palettesDir() + name);
        return WindowGen.connectedGlassPane(name, parent, AllSpriteShifts.getWoodenWindow(woodType), sideTexture, sideTexture, topTexture, renderType);
    }

    public static BlockEntry<GlassPaneBlock> standardGlassPane(String name, Supplier<? extends Block> parent, ResourceLocation sideTexture, ResourceLocation topTexture, Supplier<Supplier<RenderType>> renderType) {
        NonNullBiConsumer stateProvider = (c, p) -> p.paneBlock((PaneBlock)c.get(), sideTexture, topTexture);
        return WindowGen.glassPane(name, parent, sideTexture, topTexture, GlassPaneBlock::new, renderType, $ -> {}, stateProvider);
    }

    private static BlockEntry<ConnectedGlassPaneBlock> connectedGlassPane(String name, Supplier<? extends Block> parent, CTSpriteShiftEntry ctshift, ResourceLocation sideTexture, ResourceLocation itemSideTexture, ResourceLocation topTexture, Supplier<Supplier<RenderType>> renderType) {
        NonNullConsumer connectedTextures = CreateRegistrate.connectedTextures(new GlassPaneCTBehaviour(ctshift));
        String CGPparents = "block/connected_glass_pane/";
        String prefix = name + "_pane_";
        Function<RegistrateBlockstateProvider, ModelFile> post = WindowGen.getPaneModelProvider(CGPparents, prefix, "post", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> side = WindowGen.getPaneModelProvider(CGPparents, prefix, "side", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> sideAlt = WindowGen.getPaneModelProvider(CGPparents, prefix, "side_alt", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSide = WindowGen.getPaneModelProvider(CGPparents, prefix, "noside", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSideAlt = WindowGen.getPaneModelProvider(CGPparents, prefix, "noside_alt", sideTexture, topTexture);
        NonNullBiConsumer stateProvider = (c, p) -> p.paneBlock((PaneBlock)c.get(), (ModelFile)post.apply((RegistrateBlockstateProvider)p), (ModelFile)side.apply((RegistrateBlockstateProvider)p), (ModelFile)sideAlt.apply((RegistrateBlockstateProvider)p), (ModelFile)noSide.apply((RegistrateBlockstateProvider)p), (ModelFile)noSideAlt.apply((RegistrateBlockstateProvider)p));
        return WindowGen.glassPane(name, parent, itemSideTexture, topTexture, ConnectedGlassPaneBlock::new, renderType, connectedTextures, stateProvider);
    }

    private static Function<RegistrateBlockstateProvider, ModelFile> getPaneModelProvider(String CGPparents, String prefix, String partial, ResourceLocation sideTexture, ResourceLocation topTexture) {
        return p -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(prefix + partial, Create.asResource(CGPparents + partial))).texture("pane", sideTexture)).texture("edge", topTexture);
    }

    private static <G extends GlassPaneBlock> BlockEntry<G> glassPane(String name, Supplier<? extends Block> parent, ResourceLocation sideTexture, ResourceLocation topTexture, NonNullFunction<AbstractBlock.Properties, G> factory, Supplier<Supplier<RenderType>> renderType, NonNullConsumer<? super G> connectedTextures, NonNullBiConsumer<DataGenContext<Block, G>, RegistrateBlockstateProvider> stateProvider) {
        name = name + "_pane";
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name, factory).onRegister(connectedTextures)).addLayer(renderType).initialProperties(() -> Blocks.field_150410_aZ).blockstate(stateProvider).recipe((c, p) -> ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)c.get()), (int)16).func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)parent.get()).func_200465_a("has_ingredient", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)parent.get())).func_200464_a(p::accept)).tag(new ITag.INamedTag[]{Tags.Blocks.GLASS_PANES}).loot((t, g) -> t.func_218466_b((Block)g)).item().tag(new ITag.INamedTag[]{Tags.Items.GLASS_PANES}).model((c, p) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), new ResourceLocation("create", "item/pane"))).texture("pane", sideTexture)).texture("edge", topTexture);
        }).build()).register();
    }

    private static String palettesDir() {
        return "block/palettes/";
    }
}

