/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.LinearChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.RadialChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssembleRailType;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.tracks.ReinforcedRailBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.palettes.PavedBlock;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.worldgen.OxidizingBlock;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateGen {
    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> axisBlockProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.axisBlock(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> directionalBlockProvider(boolean customItem) {
        return (c, p) -> p.directionalBlock((Block)c.get(), BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> directionalBlockProviderIgnoresWaterlogged(boolean customItem) {
        return (c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalBlockProvider(boolean customItem) {
        return (c, p) -> p.horizontalBlock((Block)c.get(), BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalAxisBlockProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.horizontalAxisBlock(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends DirectionalAxisKineticBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> directionalAxisBlockProvider() {
        return (c, p) -> BlockStateGen.directionalAxisBlock(c, p, ($, vertical) -> p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/" + (vertical != false ? "vertical" : "horizontal"))));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalWheelProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.horizontalWheel(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <P> NonNullUnaryOperator<BlockBuilder<OxidizingBlock, P>> oxidizedBlockstate() {
        return b -> b.blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            String name = AssetLookup.getOxidizedModel(ctx.getName(), (Integer)state.func_177229_b((Property)OxidizingBlock.OXIDIZATION));
            return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeAll(name, prov.modLoc(name))).build();
        }));
    }

    private static <T extends Block> Function<BlockState, ModelFile> getBlockModel(boolean customItem, DataGenContext<Block, T> c, RegistrateBlockstateProvider p) {
        return $ -> customItem ? AssetLookup.partialBaseModel(c, p, new String[0]) : AssetLookup.standardModel(c, p);
    }

    public static <T extends Block> void directionalBlockIgnoresWaterlogged(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + 180) % 360).build();
        }, new Property[]{BlockStateProperties.field_208198_y});
    }

    public static <T extends Block> void axisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc) {
        BlockStateGen.axisBlock(ctx, prov, modelFunc, false);
    }

    public static <T extends Block> void axisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc, boolean uvLock) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).uvLock(uvLock).rotationX(axis == Direction.Axis.Y ? 0 : 90).rotationY(axis == Direction.Axis.X ? 90 : (axis == Direction.Axis.Z ? 180 : 0)).build();
        }, new Property[]{BlockStateProperties.field_208198_y});
    }

    public static <T extends Block> void horizontalAxisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208199_z);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        });
    }

    public static <T extends DirectionalAxisKineticBlock> void directionalAxisBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BiFunction<BlockState, Boolean, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            int xRot;
            boolean vertical;
            boolean alongFirst = (Boolean)state.func_177229_b((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            Direction direction = (Direction)state.func_177229_b((Property)DirectionalAxisKineticBlock.FACING);
            boolean bl = direction.func_176740_k().func_176722_c() && direction.func_176740_k() == Direction.Axis.X == alongFirst ? true : (vertical = false);
            int n = direction == Direction.DOWN ? 270 : (xRot = direction == Direction.UP ? 90 : 0);
            int yRot = direction.func_176740_k().func_200128_b() ? (alongFirst ? 0 : 90) : (int)direction.func_185119_l();
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state, vertical)).rotationX(xRot).rotationY(yRot).build();
        });
    }

    public static <T extends Block> void horizontalWheel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> modelFunc) {
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(90).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build());
    }

    public static <T extends Block> void cubeAll(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, String textureSubDir) {
        BlockStateGen.cubeAll(ctx, prov, textureSubDir, ctx.getName());
    }

    public static <T extends Block> void cubeAll(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, String textureSubDir, String name) {
        String texturePath = "block/" + textureSubDir + name;
        prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc(texturePath)));
    }

    public static <T extends Block> void pavedBlock(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, ModelFile top, ModelFile covered) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((Property)PavedBlock.COVERED) != false ? covered : top).build());
    }

    public static NonNullBiConsumer<DataGenContext<Block, CartAssemblerBlock>, RegistrateBlockstateProvider> cartAssembler() {
        return (c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            int yRotation;
            CartAssembleRailType type = (CartAssembleRailType)((Object)((Object)((Object)state.func_177229_b(CartAssemblerBlock.RAIL_TYPE))));
            Boolean powered = (Boolean)state.func_177229_b((Property)CartAssemblerBlock.POWERED);
            RailShape shape = (RailShape)state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE);
            int n = yRotation = shape == RailShape.EAST_WEST ? 270 : 0;
            if (type == CartAssembleRailType.CONTROLLER_RAIL_BACKWARDS) {
                yRotation += 180;
                type = CartAssembleRailType.CONTROLLER_RAIL;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/block_" + type.func_176610_l() + (powered != false ? "_powered" : "")))).rotationY(yRotation % 360).build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<Block, BlazeBurnerBlock>, RegistrateBlockstateProvider> blazeHeater() {
        return (c, p) -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/block"))).build();
    }

    public static NonNullBiConsumer<DataGenContext<Block, ReinforcedRailBlock>, RegistrateBlockstateProvider> reinforcedRail() {
        return (c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/block" + ((Boolean)state.func_177229_b(ReinforcedRailBlock.CONNECTS_S) != false ? "_s" : "") + ((Boolean)state.func_177229_b(ReinforcedRailBlock.CONNECTS_N) != false ? "_n" : "")))).rotationY(state.func_177229_b(ReinforcedRailBlock.RAIL_SHAPE) == RailShape.EAST_WEST ? 90 : 0).build());
    }

    public static <B extends LinearChassisBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> linearChassis() {
        return (c, p) -> {
            ResourceLocation side = p.modLoc("block/" + c.getName() + "_side");
            ResourceLocation top = p.modLoc("block/linear_chassis_end");
            ResourceLocation top_sticky = p.modLoc("block/linear_chassis_end_sticky");
            Vector<ModelBuilder> models = new Vector<ModelBuilder>(4);
            for (boolean isTopSticky : Iterate.trueAndFalse) {
                for (boolean isBottomSticky : Iterate.trueAndFalse) {
                    models.add(((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + (isTopSticky ? "_top" : "") + (isBottomSticky ? "_bottom" : ""), "block/cube_bottom_top")).texture("side", side)).texture("bottom", isBottomSticky ? top_sticky : top)).texture("top", isTopSticky ? top_sticky : top));
                }
            }
            BiFunction<Boolean, Boolean, ModelFile> modelFunc = (t, b) -> (ModelFile)models.get((t != false ? 0 : 2) + (b != false ? 0 : 1));
            BlockStateGen.axisBlock(c, p, state -> (ModelFile)modelFunc.apply((Boolean)state.func_177229_b((Property)LinearChassisBlock.STICKY_TOP), (Boolean)state.func_177229_b((Property)LinearChassisBlock.STICKY_BOTTOM)));
        };
    }

    public static <B extends RadialChassisBlock> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateBlockstateProvider> radialChassis() {
        return (c, p) -> {
            String suffix;
            String path = "block/" + c.getName();
            ResourceLocation side = p.modLoc(path + "_side");
            ResourceLocation side_sticky = p.modLoc(path + "_side_sticky");
            String templateModelPath = "block/radial_chassis";
            ModelFile.ExistingModelFile base = p.models().getExistingFile(p.modLoc(templateModelPath + "/base"));
            Vector<ModelBuilder> faces = new Vector<ModelBuilder>(3);
            Vector<ModelBuilder> stickyFaces = new Vector<ModelBuilder>(3);
            for (Direction.Axis axis : Iterate.axes) {
                suffix = "side_" + axis.func_176610_l();
                faces.add(((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "_" + suffix, p.modLoc(templateModelPath + "/" + suffix))).texture("side", side));
            }
            for (Direction.Axis axis : Iterate.axes) {
                suffix = "side_" + axis.func_176610_l();
                stickyFaces.add(((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "_" + suffix + "_sticky", p.modLoc(templateModelPath + "/" + suffix))).texture("side", side_sticky));
            }
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            BlockState propertyGetter = (BlockState)((RadialChassisBlock)c.get()).func_176223_P().func_206870_a((Property)RadialChassisBlock.field_176298_M, (Comparable)Direction.Axis.Y);
            for (Direction.Axis axis : Iterate.axes) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).rotationX(axis != Direction.Axis.Y ? 90 : 0).rotationY(axis != Direction.Axis.X ? 0 : 90).addModel()).condition((Property)RadialChassisBlock.field_176298_M, (Comparable[])new Direction.Axis[]{axis}).end();
            }
            for (Direction.Axis axis : Iterate.horizontalDirections) {
                for (boolean sticky : Iterate.trueAndFalse) {
                    for (Direction.Axis axis2 : Iterate.axes) {
                        int horizontalAngle = (int)axis.func_185119_l();
                        int index = axis2.ordinal();
                        int xRot = 0;
                        int yRot = 0;
                        if (axis2 == Direction.Axis.X) {
                            xRot = -horizontalAngle + 180;
                        }
                        if (axis2 == Direction.Axis.Y) {
                            yRot = horizontalAngle;
                        }
                        if (axis2 == Direction.Axis.Z) {
                            yRot = -horizontalAngle + 270;
                            if (axis.func_176740_k() == Direction.Axis.Z) {
                                index = 0;
                                xRot = horizontalAngle + 180;
                                yRot = 90;
                            }
                        }
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(sticky ? stickyFaces : faces).get(index)).rotationX((xRot + 360) % 360).rotationY((yRot + 360) % 360).addModel()).condition((Property)RadialChassisBlock.field_176298_M, (Comparable[])new Direction.Axis[]{axis2}).condition((Property)((RadialChassisBlock)c.get()).getGlueableSide(propertyGetter, (Direction)axis), (Comparable[])new Boolean[]{sticky}).end();
                    }
                }
            }
        };
    }

    public static <P extends EncasedPipeBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> encasedPipe() {
        return (c, p) -> {
            ModelFile open = AssetLookup.partialBaseModel(c, p, "open");
            ModelFile flat = AssetLookup.partialBaseModel(c, p, "flat");
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            for (boolean flatPass : Iterate.trueAndFalse) {
                for (Direction d : Iterate.directions) {
                    int verticalAngle = d == Direction.UP ? 90 : (d == Direction.DOWN ? -90 : 0);
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(flatPass ? flat : open).rotationX(verticalAngle).rotationY((int)(d.func_185119_l() + (float)(d.func_176740_k().func_200128_b() ? 90 : 0)) % 360).addModel()).condition((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable[])new Boolean[]{!flatPass}).end();
                }
            }
        };
    }

    public static <P extends FluidPipeBlock> NonNullBiConsumer<DataGenContext<Block, P>, RegistrateBlockstateProvider> pipe() {
        return (c, p) -> {
            String path = "block/" + c.getName();
            String LU = "lu";
            String RU = "ru";
            String LD = "ld";
            String RD = "rd";
            String LR = "lr";
            String UD = "ud";
            String NONE = "none";
            ImmutableList orientations = ImmutableList.of((Object)LU, (Object)RU, (Object)LD, (Object)RD, (Object)LR, (Object)UD, (Object)NONE);
            ImmutableMap uvs = ImmutableMap.builder().put((Object)LU, (Object)Pair.of((Object)8, (Object)12)).put((Object)RU, (Object)Pair.of((Object)0, (Object)12)).put((Object)LD, (Object)Pair.of((Object)12, (Object)8)).put((Object)RD, (Object)Pair.of((Object)8, (Object)8)).put((Object)LR, (Object)Pair.of((Object)4, (Object)12)).put((Object)UD, (Object)Pair.of((Object)0, (Object)8)).put((Object)NONE, (Object)Pair.of((Object)12, (Object)12)).build();
            IdentityHashMap<Direction.Axis, ResourceLocation> coreTemplates = new IdentityHashMap<Direction.Axis, ResourceLocation>();
            HashMap<Pair<String, Direction.Axis>, ModelFile> coreModels = new HashMap<Pair<String, Direction.Axis>, ModelFile>();
            for (Direction.Axis axis : Iterate.axes) {
                coreTemplates.put(axis, p.modLoc(path + "/core_" + axis.func_176610_l()));
            }
            ModelFile end = AssetLookup.partialBaseModel(c, p, "end");
            for (Direction.Axis axis : Iterate.axes) {
                ResourceLocation resourceLocation = (ResourceLocation)coreTemplates.get(axis);
                for (String s : orientations) {
                    Pair key = Pair.of((Object)s, (Object)axis);
                    String modelName = path + "/" + s + "_" + axis.func_176610_l();
                    coreModels.put((Pair<String, Direction.Axis>)key, (ModelFile)((BlockModelBuilder)p.models().withExistingParent(modelName, resourceLocation)).element().from(4.0f, 4.0f, 4.0f).to(12.0f, 12.0f, 12.0f).face(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis)).end().face(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis)).end().faces((arg_0, arg_1) -> BlockStateGen.lambda$null$28((Map)uvs, s, arg_0, arg_1)).end());
                }
            }
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((Block)c.get());
            for (Direction direction : Iterate.directions) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(end).rotationX(direction == Direction.UP ? 0 : (direction == Direction.DOWN ? 180 : 90)).rotationY((int)(direction.func_185119_l() + 180.0f) % 360).addModel()).condition((Property)FluidPipeBlock.field_196491_B.get(direction), (Comparable[])new Boolean[]{true}).end();
            }
            for (Direction direction : Iterate.axes) {
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, LU, true, false, true, false);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, RU, true, false, false, true);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, LD, false, true, true, false);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, RD, false, true, false, true);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, UD, true, true, false, false);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, UD, true, false, false, false);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, UD, false, true, false, false);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, LR, false, false, true, true);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, LR, false, false, true, false);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, LR, false, false, false, true);
                BlockStateGen.putPart(coreModels, builder, (Direction.Axis)direction, NONE, false, false, false, false);
            }
        };
    }

    private static void putPart(Map<Pair<String, Direction.Axis>, ModelFile> coreModels, MultiPartBlockStateBuilder builder, Direction.Axis axis, String s, boolean up, boolean down, boolean left, boolean right) {
        Direction positiveAxis = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Map propertyMap = FluidPipeBlock.field_196491_B;
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(coreModels.get(Pair.of((Object)s, (Object)axis))).addModel()).condition((Property)propertyMap.get(Pointing.UP.getCombinedDirection(positiveAxis)), (Comparable[])new Boolean[]{up}).condition((Property)propertyMap.get(Pointing.LEFT.getCombinedDirection(positiveAxis)), (Comparable[])new Boolean[]{left}).condition((Property)propertyMap.get(Pointing.RIGHT.getCombinedDirection(positiveAxis)), (Comparable[])new Boolean[]{right}).condition((Property)propertyMap.get(Pointing.DOWN.getCombinedDirection(positiveAxis)), (Comparable[])new Boolean[]{down}).end();
    }

    private static /* synthetic */ void lambda$null$28(Map uvs, String s, Direction d, ModelBuilder.ElementBuilder.FaceBuilder builder) {
        Pair pair = (Pair)uvs.get(s);
        float u = ((Integer)pair.getKey()).intValue();
        float v = ((Integer)pair.getValue()).intValue();
        if (d == Direction.UP) {
            builder.uvs(u, v + 4.0f, u + 4.0f, v);
        } else if (d.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            builder.uvs(u + 4.0f, v, u, v + 4.0f);
        } else {
            builder.uvs(u, v, u + 4.0f, v + 4.0f);
        }
        builder.texture("#0");
    }
}

