/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.simibubi.create.content.contraptions.goggles.GoggleConfigScreen;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public class ConfigureConfigPacket
extends SimplePacketBase {
    private final String option;
    private final String value;

    public ConfigureConfigPacket(String option, String value) {
        this.option = option;
        this.value = value;
    }

    public ConfigureConfigPacket(PacketBuffer buffer) {
        this.option = buffer.func_150789_c(Short.MAX_VALUE);
        this.value = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_180714_a(this.option);
        buffer.func_180714_a(this.value);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                Actions.valueOf(this.option).performAction(this.value);
            }
            catch (IllegalArgumentException e) {
                LogManager.getLogger().warn("Received ConfigureConfigPacket with invalid Option: " + this.option);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    static enum Actions {
        rainbowDebug(() -> Actions::rainbowDebug),
        overlayScreen(() -> Actions::overlayScreen),
        fixLighting(() -> Actions::experimentalLighting),
        overlayReset(() -> Actions::overlayReset);

        private final Supplier<Consumer<String>> consumer;

        private Actions(Supplier<Consumer<String>> action) {
            this.consumer = action;
        }

        void performAction(String value) {
            this.consumer.get().accept(value);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void rainbowDebug(String value) {
            AllConfigs.CLIENT.rainbowDebug.set(Boolean.parseBoolean(value));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void overlayReset(String value) {
            AllConfigs.CLIENT.overlayOffsetX.set(0);
            AllConfigs.CLIENT.overlayOffsetY.set(0);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void overlayScreen(String value) {
            ScreenOpener.open(new GoggleConfigScreen());
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void experimentalLighting(String value) {
            ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.set((Object)true);
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
    }
}

