/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.simibubi.create.foundation.advancement.CriterionTriggerBase;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.advancement.KineticBlockTrigger;
import com.simibubi.create.foundation.advancement.SimpleTrigger;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class AllTriggers {
    private static List<CriterionTriggerBase<?>> triggers = new LinkedList();
    public static KineticBlockTrigger KINETIC_BLOCK = AllTriggers.add(new KineticBlockTrigger("kinetic_block"));
    public static SimpleTrigger ROTATION = AllTriggers.simple("rotation");
    public static SimpleTrigger OVERSTRESSED = AllTriggers.simple("overstressed");
    public static SimpleTrigger SHIFTING_GEARS = AllTriggers.simple("shifting_gears");
    public static SimpleTrigger CONNECT_BELT = AllTriggers.simple("connect_belt");
    public static SimpleTrigger BONK = AllTriggers.simple("bonk");
    public static SimpleTrigger WATER_WHEEL = AllTriggers.simple("water_wheel");
    public static SimpleTrigger LAVA_WHEEL = AllTriggers.simple("lava_wheel");
    public static SimpleTrigger CHOCOLATE_WHEEL = AllTriggers.simple("chocolate_wheel");
    public static SimpleTrigger DEPLOYER_BOOP = AllTriggers.simple("deployer");
    public static SimpleTrigger ABSORBED_LIGHT = AllTriggers.simple("light_absorbed");
    public static SimpleTrigger SPEED_READ = AllTriggers.simple("speed_read");
    public static SimpleTrigger BASIN_THROW = AllTriggers.simple("basin");
    public static SimpleTrigger PRESS_COMPACT = AllTriggers.simple("compact");
    public static SimpleTrigger UPGRADED_ZAPPER = AllTriggers.simple("upgraded_zapper");
    public static SimpleTrigger EXTENDO = AllTriggers.simple("extendo");
    public static SimpleTrigger GIGA_EXTENDO = AllTriggers.simple("giga_extendo");
    public static SimpleTrigger MECHANICAL_ARM = AllTriggers.simple("mechanical_arm");
    public static SimpleTrigger MUSICAL_ARM = AllTriggers.simple("musical_arm");
    public static SimpleTrigger CUCKOO = AllTriggers.simple("cuckoo");
    public static SimpleTrigger BRACKET_SHAFT = AllTriggers.simple("bracket_shaft");
    public static SimpleTrigger BRACKET_COG = AllTriggers.simple("bracket_cog");
    public static SimpleTrigger BRACKET_PIPE = AllTriggers.simple("bracket_pipe");
    public static SimpleTrigger CASING_SHAFT = AllTriggers.simple("casing_shaft");
    public static SimpleTrigger CASING_BELT = AllTriggers.simple("casing_belt");
    public static SimpleTrigger CASING_PIPE = AllTriggers.simple("casing_pipe");
    public static SimpleTrigger WINDMILL = AllTriggers.simple("windmill");
    public static SimpleTrigger MAXED_WINDMILL = AllTriggers.simple("maxed_windmill");
    public static SimpleTrigger PLACE_TUNNEL = AllTriggers.simple("place_tunnel");
    public static SimpleTrigger CONNECT_TUNNEL = AllTriggers.simple("connect_tunnel");
    public static SimpleTrigger UPWARD_CHUTE = AllTriggers.simple("upward_chute");
    public static SimpleTrigger FAN = AllTriggers.simple("fan");
    public static SimpleTrigger FAN_LAVA = AllTriggers.simple("fan_lava");
    public static SimpleTrigger FAN_SMOKE = AllTriggers.simple("fan_smoke");
    public static SimpleTrigger FAN_WATER = AllTriggers.simple("fan_water");
    public static SimpleTrigger BELT_FUNNEL = AllTriggers.simple("belt_funnel");
    public static SimpleTrigger BELT_FUNNEL_KISS = AllTriggers.simple("belt_funnel_kiss");
    public static SimpleTrigger CLOCKWORK_BEARING = AllTriggers.simple("clockwork_bearing");
    public static SimpleTrigger ARM_MANY_TARGETS = AllTriggers.simple("arm_many_targets");
    public static SimpleTrigger ARM_BLAZE_BURNER = AllTriggers.simple("arm_blaze_burner");
    public static SimpleTrigger FLYWHEEL = AllTriggers.simple("flywheel");
    public static SimpleTrigger OVERSTRESS_FLYWHEEL = AllTriggers.simple("overstress_flywheel");
    public static SimpleTrigger ITEM_DRAIN = AllTriggers.simple("item_drain");
    public static SimpleTrigger CHAINED_ITEM_DRAIN = AllTriggers.simple("chained_item_drain");
    public static SimpleTrigger SPOUT = AllTriggers.simple("spout");
    public static SimpleTrigger SPOUT_POTION = AllTriggers.simple("spout_potion");
    public static SimpleTrigger GLASS_PIPE = AllTriggers.simple("glass_pipe");
    public static SimpleTrigger PIPE_COLLISION = AllTriggers.simple("pipe_collision");
    public static SimpleTrigger PIPE_SPILL = AllTriggers.simple("pipe_spill");
    public static SimpleTrigger HOSE_PULLEY = AllTriggers.simple("hose_pulley");
    public static SimpleTrigger INFINITE_WATER = AllTriggers.simple("infinite_water");
    public static SimpleTrigger INFINITE_LAVA = AllTriggers.simple("infinite_lava");
    public static SimpleTrigger INFINITE_CHOCOLATE = AllTriggers.simple("infinite_chocolate");
    public static SimpleTrigger MIXER_MIX = AllTriggers.simple("mixer");

    private static SimpleTrigger simple(String id) {
        return AllTriggers.add(new SimpleTrigger(id));
    }

    private static <T extends CriterionTriggerBase<?>> T add(T instance) {
        triggers.add(instance);
        return instance;
    }

    public static void register() {
        triggers.forEach(CriteriaTriggers::func_192118_a);
    }

    public static void triggerFor(ITriggerable trigger, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            trigger.trigger((ServerPlayerEntity)player);
        }
    }

    public static void triggerForNearbyPlayers(ITriggerable trigger, IWorld world, BlockPos pos, int range) {
        AllTriggers.triggerForNearbyPlayers(trigger, world, pos, range, player -> true);
    }

    public static void triggerForNearbyPlayers(ITriggerable trigger, IWorld world, BlockPos pos, int range, Predicate<PlayerEntity> playerFilter) {
        if (world == null) {
            return;
        }
        if (world.func_201670_d()) {
            return;
        }
        List<ServerPlayerEntity> players = AllTriggers.getPlayersInRange(world, pos, range);
        players.stream().filter(playerFilter).forEach(trigger::trigger);
    }

    public static List<ServerPlayerEntity> getPlayersInRange(IWorld world, BlockPos pos, int range) {
        List players = world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_186662_g((double)range));
        return players;
    }
}

