/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public class SchematicEditScreen
extends AbstractSimiScreen {
    private TextFieldWidget xInput;
    private TextFieldWidget yInput;
    private TextFieldWidget zInput;
    private IconButton confirmButton;
    private final List<ITextComponent> rotationOptions = Lang.translatedOptions("schematic.rotation", "none", "cw90", "cw180", "cw270");
    private final List<ITextComponent> mirrorOptions = Lang.translatedOptions("schematic.mirror", "none", "leftRight", "frontBack");
    private final ITextComponent rotationLabel = Lang.translate("schematic.rotation", new Object[0]);
    private final ITextComponent mirrorLabel = Lang.translate("schematic.mirror", new Object[0]);
    private ScrollInput rotationArea;
    private ScrollInput mirrorArea;
    private SchematicHandler handler;

    protected void func_231160_c_() {
        AllGuiTextures background = AllGuiTextures.SCHEMATIC;
        this.setWindowSize(background.width + 50, background.height);
        int x = this.guiLeft;
        int y = this.guiTop;
        this.handler = CreateClient.schematicHandler;
        this.xInput = new TextFieldWidget(this.field_230712_o_, x + 50, y + 26, 34, 10, StringTextComponent.field_240750_d_);
        this.yInput = new TextFieldWidget(this.field_230712_o_, x + 90, y + 26, 34, 10, StringTextComponent.field_240750_d_);
        this.zInput = new TextFieldWidget(this.field_230712_o_, x + 130, y + 26, 34, 10, StringTextComponent.field_240750_d_);
        BlockPos anchor = this.handler.getTransformation().getAnchor();
        if (this.handler.isDeployed()) {
            this.xInput.func_146180_a("" + anchor.func_177958_n());
            this.yInput.func_146180_a("" + anchor.func_177956_o());
            this.zInput.func_146180_a("" + anchor.func_177952_p());
        } else {
            TextFieldWidget[] alt = this.field_230706_i_.field_71439_g.func_233580_cy_();
            this.xInput.func_146180_a("" + alt.func_177958_n());
            this.yInput.func_146180_a("" + alt.func_177956_o());
            this.zInput.func_146180_a("" + alt.func_177952_p());
        }
        for (TextFieldWidget widget : new TextFieldWidget[]{this.xInput, this.yInput, this.zInput}) {
            widget.func_146203_f(6);
            widget.func_146185_a(false);
            widget.func_146193_g(0xFFFFFF);
            widget.func_231049_c__(false);
            widget.func_231044_a_(0.0, 0.0, 0);
            widget.func_200675_a(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    Integer.parseInt(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
        PlacementSettings settings = this.handler.getTransformation().toSettings();
        Label labelR = new Label(x + 50, y + 48, StringTextComponent.field_240750_d_).withShadow();
        this.rotationArea = new SelectionScrollInput(x + 45, y + 43, 118, 18).forOptions(this.rotationOptions).titled(this.rotationLabel.func_230531_f_()).setState(settings.func_186215_c().ordinal()).writingTo(labelR);
        Label labelM = new Label(x + 50, y + 70, StringTextComponent.field_240750_d_).withShadow();
        this.mirrorArea = new SelectionScrollInput(x + 45, y + 65, 118, 18).forOptions(this.mirrorOptions).titled(this.mirrorLabel.func_230531_f_()).setState(settings.func_186212_b().ordinal()).writingTo(labelM);
        Collections.addAll(this.widgets, this.xInput, this.yInput, this.zInput);
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{labelR, labelM, this.rotationArea, this.mirrorArea});
        this.confirmButton = new IconButton(this.guiLeft + background.width - 33, this.guiTop + background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
        super.func_231160_c_();
    }

    @Override
    public boolean func_231046_a_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        String coords;
        if (SchematicEditScreen.func_231168_h_((int)code) && (coords = this.field_230706_i_.field_195559_v.func_197965_a()) != null && !coords.isEmpty()) {
            coords.replaceAll(" ", "");
            String[] split = coords.split(",");
            if (split.length == 3) {
                boolean valid = true;
                for (String s : split) {
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                }
                if (valid) {
                    this.xInput.func_146180_a(split[0]);
                    this.yInput.func_146180_a(split[1]);
                    this.zInput.func_146180_a(split[2]);
                    return true;
                }
            }
        }
        return super.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected void renderWindow(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        AllGuiTextures.SCHEMATIC.draw(matrixStack, (AbstractGui)this, x, y);
        this.field_230712_o_.func_238405_a_(matrixStack, this.handler.getCurrentSchematicName(), (float)(x + 93 - this.field_230712_o_.func_78256_a(this.handler.getCurrentSchematicName()) / 2), (float)(y + 3), 0xFFFFFF);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.guiLeft + 200), (double)(this.guiTop + 130), 0.0);
        matrixStack.func_227862_a_(3.0f, 3.0f, 3.0f);
        GuiGameElement.of(AllItems.SCHEMATIC.asStack()).render(matrixStack);
        matrixStack.func_227865_b_();
    }

    public void func_231164_f_() {
        boolean validCoords = true;
        BlockPos newLocation = null;
        try {
            newLocation = new BlockPos(Integer.parseInt(this.xInput.func_146179_b()), Integer.parseInt(this.yInput.func_146179_b()), Integer.parseInt(this.zInput.func_146179_b()));
        }
        catch (NumberFormatException e) {
            validCoords = false;
        }
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(Rotation.values()[this.rotationArea.getState()]);
        settings.func_186214_a(Mirror.values()[this.mirrorArea.getState()]);
        if (validCoords && newLocation != null) {
            ItemStack item = this.handler.getActiveSchematicItem();
            if (item != null) {
                item.func_77978_p().func_74757_a("Deployed", true);
                item.func_77978_p().func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)newLocation));
            }
            this.handler.getTransformation().init(newLocation, settings, this.handler.getBounds());
            this.handler.markDirty();
            this.handler.deploy();
        }
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        if (this.confirmButton.func_230449_g_()) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }
}

