/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.server.ServerWorld;

public class SchematicWorld
extends WrappedWorld
implements IServerWorld {
    private Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
    private Map<BlockPos, TileEntity> tileEntities = new HashMap<BlockPos, TileEntity>();
    private List<TileEntity> renderedTileEntities;
    private List<Entity> entities;
    private MutableBoundingBox bounds = new MutableBoundingBox();
    public BlockPos anchor;
    public boolean renderMode;

    public SchematicWorld(World original) {
        this(BlockPos.field_177992_a, original);
    }

    public SchematicWorld(BlockPos anchor, World original) {
        super(original);
        this.anchor = anchor;
        this.entities = new ArrayList<Entity>();
        this.renderedTileEntities = new ArrayList<TileEntity>();
    }

    public Set<BlockPos> getAllPositions() {
        return this.blocks.keySet();
    }

    @Override
    public boolean func_217376_c(Entity entityIn) {
        if (entityIn instanceof ItemFrameEntity) {
            ((ItemFrameEntity)entityIn).func_82335_i().func_77982_d(null);
        }
        if (entityIn instanceof ArmorStandEntity) {
            ArmorStandEntity armorStandEntity = (ArmorStandEntity)entityIn;
            armorStandEntity.func_184209_aF().forEach(stack -> stack.func_77982_d(null));
        }
        return this.entities.add(entityIn);
    }

    public Stream<Entity> getEntities() {
        return this.entities.stream();
    }

    @Override
    public TileEntity func_175625_s(BlockPos pos) {
        if (SchematicWorld.func_189509_E((BlockPos)pos)) {
            return null;
        }
        if (this.tileEntities.containsKey(pos)) {
            return this.tileEntities.get(pos);
        }
        if (!this.blocks.containsKey(pos.func_177973_b((Vector3i)this.anchor))) {
            return null;
        }
        BlockState blockState = this.func_180495_p(pos);
        if (blockState.hasTileEntity()) {
            try {
                TileEntity tileEntity = blockState.createTileEntity((IBlockReader)this);
                if (tileEntity != null) {
                    tileEntity.func_226984_a_((World)this, pos);
                    this.tileEntities.put(pos, tileEntity);
                    this.renderedTileEntities.add(tileEntity);
                }
                return tileEntity;
            }
            catch (Exception e) {
                Create.logger.debug("Could not create TE of block " + blockState + ": " + e);
            }
        }
        return null;
    }

    @Override
    public BlockState func_180495_p(BlockPos globalPos) {
        BlockPos pos = globalPos.func_177973_b((Vector3i)this.anchor);
        if (pos.func_177956_o() - this.bounds.field_78895_b == -1 && !this.renderMode) {
            return Blocks.field_196658_i.func_176223_P();
        }
        if (this.getBounds().func_175898_b((Vector3i)pos) && this.blocks.containsKey(pos)) {
            BlockState blockState = this.blocks.get(pos);
            if (BlockHelper.hasBlockStateProperty(blockState, BlockStateProperties.field_208190_q)) {
                blockState = (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false));
            }
            return blockState;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public Map<BlockPos, BlockState> getBlockMap() {
        return this.blocks;
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public Biome func_226691_t_(BlockPos pos) {
        return BiomeRegistry.field_244201_b;
    }

    public int func_226658_a_(LightType p_226658_1_, BlockPos p_226658_2_) {
        return 10;
    }

    public List<Entity> func_175674_a(Entity arg0, AxisAlignedBB arg1, Predicate<? super Entity> arg2) {
        return Collections.emptyList();
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> arg0, AxisAlignedBB arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    @Override
    public List<? extends PlayerEntity> func_217369_A() {
        return Collections.emptyList();
    }

    public int func_175657_ab() {
        return 0;
    }

    @Override
    public boolean func_217375_a(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.func_180495_p(pos));
    }

    public boolean func_175655_b(BlockPos arg0, boolean arg1) {
        return this.func_180501_a(arg0, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public boolean func_217377_a(BlockPos arg0, boolean arg1) {
        return this.func_180501_a(arg0, Blocks.field_150350_a.func_176223_P(), 3);
    }

    @Override
    public boolean func_180501_a(BlockPos pos, BlockState arg1, int arg2) {
        pos = pos.func_177973_b((Vector3i)this.anchor);
        this.bounds.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos.func_177982_a(1, 1, 1)));
        this.blocks.put(pos, arg1);
        return true;
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    public MutableBoundingBox getBounds() {
        return this.bounds;
    }

    public Iterable<TileEntity> getRenderedTileEntities() {
        return this.renderedTileEntities;
    }

    public ServerWorld func_201672_e() {
        if (this.world instanceof ServerWorld) {
            return (ServerWorld)this.world;
        }
        throw new IllegalStateException("Cannot use IServerWorld#getWorld in a client environment");
    }
}

