/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterScreenPacket;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class AttributeFilterScreen
extends AbstractFilterScreen<AttributeFilterContainer> {
    private static final String PREFIX = "gui.attribute_filter.";
    private IconButton whitelistDis;
    private IconButton whitelistCon;
    private IconButton blacklist;
    private Indicator whitelistDisIndicator;
    private Indicator whitelistConIndicator;
    private Indicator blacklistIndicator;
    private IconButton add;
    private IconButton addInverted;
    private ITextComponent addDESC = Lang.translate("gui.attribute_filter.add_attribute", new Object[0]);
    private ITextComponent addInvertedDESC = Lang.translate("gui.attribute_filter.add_inverted_attribute", new Object[0]);
    private ITextComponent allowDisN = Lang.translate("gui.attribute_filter.allow_list_disjunctive", new Object[0]);
    private ITextComponent allowDisDESC = Lang.translate("gui.attribute_filter.allow_list_disjunctive.description", new Object[0]);
    private ITextComponent allowConN = Lang.translate("gui.attribute_filter.allow_list_conjunctive", new Object[0]);
    private ITextComponent allowConDESC = Lang.translate("gui.attribute_filter.allow_list_conjunctive.description", new Object[0]);
    private ITextComponent denyN = Lang.translate("gui.attribute_filter.deny_list", new Object[0]);
    private ITextComponent denyDESC = Lang.translate("gui.attribute_filter.deny_list.description", new Object[0]);
    private ITextComponent referenceH = Lang.translate("gui.attribute_filter.add_reference_item", new Object[0]);
    private ITextComponent noSelectedT = Lang.translate("gui.attribute_filter.no_selected_attributes", new Object[0]);
    private ITextComponent selectedT = Lang.translate("gui.attribute_filter.selected_attributes", new Object[0]);
    private ItemStack lastItemScanned = ItemStack.field_190927_a;
    private List<ItemAttribute> attributesOfItem = new ArrayList<ItemAttribute>();
    private List<ITextComponent> selectedAttributes = new ArrayList<ITextComponent>();
    private SelectionScrollInput attributeSelector;
    private Label attributeSelectorLabel;

    public AttributeFilterScreen(AttributeFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title, AllGuiTextures.ATTRIBUTE_FILTER);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.whitelistDis = new IconButton(x + 47, y + 59, AllIcons.I_WHITELIST_OR);
        this.whitelistDis.setToolTip(this.allowDisN);
        this.whitelistCon = new IconButton(x + 65, y + 59, AllIcons.I_WHITELIST_AND);
        this.whitelistCon.setToolTip(this.allowConN);
        this.blacklist = new IconButton(x + 83, y + 59, AllIcons.I_WHITELIST_NOT);
        this.blacklist.setToolTip(this.denyN);
        this.whitelistDisIndicator = new Indicator(x + 47, y + 53, StringTextComponent.field_240750_d_);
        this.whitelistConIndicator = new Indicator(x + 65, y + 53, StringTextComponent.field_240750_d_);
        this.blacklistIndicator = new Indicator(x + 83, y + 53, StringTextComponent.field_240750_d_);
        this.widgets.addAll(Arrays.asList(new AbstractSimiWidget[]{this.blacklist, this.whitelistCon, this.whitelistDis, this.blacklistIndicator, this.whitelistConIndicator, this.whitelistDisIndicator}));
        this.add = new IconButton(x + 182, y + 21, AllIcons.I_ADD);
        this.widgets.add(this.add);
        this.addInverted = new IconButton(x + 200, y + 21, AllIcons.I_ADD_INVERTED_ATTRIBUTE);
        this.widgets.add(this.addInverted);
        this.add.setToolTip(this.addDESC);
        this.addInverted.setToolTip(this.addInvertedDESC);
        this.handleIndicators();
        this.attributeSelectorLabel = new Label(x + 43, y + 26, StringTextComponent.field_240750_d_).colored(15985630).withShadow();
        this.attributeSelector = new SelectionScrollInput(x + 39, y + 21, 137, 18);
        this.attributeSelector.forOptions(Arrays.asList(StringTextComponent.field_240750_d_));
        this.attributeSelector.removeCallback();
        this.referenceItemChanged(((AttributeFilterContainer)this.field_147002_h).filterInventory.getStackInSlot(0));
        this.widgets.add(this.attributeSelector);
        this.widgets.add(this.attributeSelectorLabel);
        this.selectedAttributes.clear();
        this.selectedAttributes.add((ITextComponent)(((AttributeFilterContainer)this.field_147002_h).selectedAttributes.isEmpty() ? this.noSelectedT : this.selectedT).func_230531_f_().func_240699_a_(TextFormatting.YELLOW));
        ((AttributeFilterContainer)this.field_147002_h).selectedAttributes.forEach(at -> this.selectedAttributes.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)((ItemAttribute)at.getFirst()).format((Boolean)at.getSecond())).func_240699_a_(TextFormatting.GRAY)));
    }

    private void referenceItemChanged(ItemStack stack) {
        this.lastItemScanned = stack;
        if (stack.func_190926_b()) {
            this.attributeSelector.field_230693_o_ = false;
            this.attributeSelector.field_230694_p_ = false;
            this.attributeSelectorLabel.text = this.referenceH.func_230531_f_().func_240699_a_(TextFormatting.ITALIC);
            this.add.field_230693_o_ = false;
            this.addInverted.field_230693_o_ = false;
            this.attributeSelector.calling(s -> {});
            return;
        }
        this.add.field_230693_o_ = true;
        this.addInverted.field_230693_o_ = true;
        this.attributeSelector.titled(stack.func_200301_q().func_230531_f_().func_240702_b_("..."));
        this.attributesOfItem.clear();
        for (ItemAttribute itemAttribute : ItemAttribute.types) {
            this.attributesOfItem.addAll(itemAttribute.listAttributesOf(stack, (World)this.field_230706_i_.field_71441_e));
        }
        List<ITextComponent> options = this.attributesOfItem.stream().map(a -> a.format(false)).collect(Collectors.toList());
        this.attributeSelector.forOptions(options);
        this.attributeSelector.field_230693_o_ = true;
        this.attributeSelector.field_230694_p_ = true;
        this.attributeSelector.setState(0);
        this.attributeSelector.calling(i -> {
            this.attributeSelectorLabel.setTextAndTrim((ITextComponent)options.get((int)i), true, 112);
            ItemAttribute selected = this.attributesOfItem.get((int)i);
            for (Pair<ItemAttribute, Boolean> existing : ((AttributeFilterContainer)this.field_147002_h).selectedAttributes) {
                CompoundNBT testTag = new CompoundNBT();
                CompoundNBT testTag2 = new CompoundNBT();
                existing.getFirst().serializeNBT(testTag);
                selected.serializeNBT(testTag2);
                if (!testTag.equals((Object)testTag2)) continue;
                this.add.field_230693_o_ = false;
                this.addInverted.field_230693_o_ = false;
                return;
            }
            this.add.field_230693_o_ = true;
            this.addInverted.field_230693_o_ = true;
        });
        this.attributeSelector.onChanged();
    }

    @Override
    public void renderWindowForeground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = ((AttributeFilterContainer)this.field_147002_h).filterInventory.getStackInSlot(1);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 32.0);
        this.func_230926_e_(200);
        this.field_230707_j_.field_77023_b = 200.0f;
        this.field_230707_j_.func_180453_a(this.field_230712_o_, stack, this.field_147003_i + 22, this.field_147009_r + 57, String.valueOf(this.selectedAttributes.size() - 1));
        this.func_230926_e_(0);
        this.field_230707_j_.field_77023_b = 0.0f;
        matrixStack.func_227865_b_();
        super.renderWindowForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ItemStack stackInSlot = ((AttributeFilterContainer)this.field_147002_h).filterInventory.getStackInSlot(0);
        if (!stackInSlot.equals(this.lastItemScanned, false)) {
            this.referenceItemChanged(stackInSlot);
        }
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.field_147006_u.field_75222_d == 37) {
                this.func_243308_b(matrixStack, this.selectedAttributes, mouseX, mouseY);
                return;
            }
            this.func_230457_a_(matrixStack, this.field_147006_u.func_75211_c(), mouseX, mouseY);
        }
        super.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected List<IconButton> getTooltipButtons() {
        return Arrays.asList(this.blacklist, this.whitelistCon, this.whitelistDis);
    }

    @Override
    protected List<IFormattableTextComponent> getTooltipDescriptions() {
        return Arrays.asList(this.denyDESC.func_230531_f_(), this.allowConDESC.func_230531_f_(), this.allowDisDESC.func_230531_f_());
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        boolean mouseClicked = super.func_231044_a_(x, y, button);
        if (button != 0) {
            return mouseClicked;
        }
        if (this.blacklist.func_230449_g_()) {
            ((AttributeFilterContainer)this.field_147002_h).whitelistMode = AttributeFilterContainer.WhitelistMode.BLACKLIST;
            this.sendOptionUpdate(FilterScreenPacket.Option.BLACKLIST);
            return true;
        }
        if (this.whitelistCon.func_230449_g_()) {
            ((AttributeFilterContainer)this.field_147002_h).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST2);
            return true;
        }
        if (this.whitelistDis.func_230449_g_()) {
            ((AttributeFilterContainer)this.field_147002_h).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST);
            return true;
        }
        if (this.add.func_230449_g_() && this.add.field_230693_o_) {
            return this.handleAddedAttibute(false);
        }
        if (this.addInverted.func_230449_g_() && this.addInverted.field_230693_o_) {
            return this.handleAddedAttibute(true);
        }
        return mouseClicked;
    }

    protected boolean handleAddedAttibute(boolean inverted) {
        int index = this.attributeSelector.getState();
        if (index >= this.attributesOfItem.size()) {
            return false;
        }
        this.add.field_230693_o_ = false;
        this.addInverted.field_230693_o_ = false;
        CompoundNBT tag = new CompoundNBT();
        ItemAttribute itemAttribute = this.attributesOfItem.get(index);
        itemAttribute.serializeNBT(tag);
        AllPackets.channel.sendToServer((Object)new FilterScreenPacket(inverted ? FilterScreenPacket.Option.ADD_INVERTED_TAG : FilterScreenPacket.Option.ADD_TAG, tag));
        ((AttributeFilterContainer)this.field_147002_h).appendSelectedAttribute(itemAttribute, inverted);
        if (((AttributeFilterContainer)this.field_147002_h).selectedAttributes.size() == 1) {
            this.selectedAttributes.set(0, (ITextComponent)this.selectedT.func_230531_f_().func_240699_a_(TextFormatting.YELLOW));
        }
        this.selectedAttributes.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)itemAttribute.format(inverted)).func_240699_a_(TextFormatting.GRAY));
        return true;
    }

    @Override
    protected void contentsCleared() {
        this.selectedAttributes.clear();
        this.selectedAttributes.add((ITextComponent)this.noSelectedT.func_230531_f_().func_240699_a_(TextFormatting.YELLOW));
        if (!this.lastItemScanned.func_190926_b()) {
            this.add.field_230693_o_ = true;
            this.addInverted.field_230693_o_ = true;
        }
    }

    @Override
    protected boolean isButtonEnabled(IconButton button) {
        if (button == this.blacklist) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode != AttributeFilterContainer.WhitelistMode.BLACKLIST;
        }
        if (button == this.whitelistCon) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode != AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
        }
        if (button == this.whitelistDis) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode != AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
        }
        return true;
    }

    @Override
    protected boolean isIndicatorOn(Indicator indicator) {
        if (indicator == this.blacklistIndicator) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode == AttributeFilterContainer.WhitelistMode.BLACKLIST;
        }
        if (indicator == this.whitelistConIndicator) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
        }
        if (indicator == this.whitelistDisIndicator) {
            return ((AttributeFilterContainer)this.field_147002_h).whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
        }
        return false;
    }
}

