/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkBlock;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkFrequencySlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneLinkTileEntity
extends SmartTileEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private LinkBehaviour link;
    private boolean transmitter;

    public RedstoneLinkTileEntity(TileEntityType<? extends RedstoneLinkTileEntity> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        Pair<ValueBoxTransform, ValueBoxTransform> slots = ValueBoxTransform.Dual.makeSlots(RedstoneLinkFrequencySlot::new);
        this.link = this.transmitter ? LinkBehaviour.transmitter(this, slots, this::getSignal) : LinkBehaviour.receiver(this, slots, this::setSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(int power) {
        if (this.receivedSignal != power) {
            this.receivedSignalChanged = true;
        }
        this.receivedSignal = power;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Transmitter", this.transmitter);
        compound.func_74768_a("Receive", this.getReceivedSignal());
        compound.func_74757_a("ReceivedChanged", this.receivedSignalChanged);
        compound.func_74768_a("Transmit", this.transmittedSignal);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.transmitter = compound.func_74767_n("Transmitter");
        super.fromTag(state, compound, clientPacket);
        this.receivedSignal = compound.func_74762_e("Receive");
        this.receivedSignalChanged = compound.func_74767_n("ReceivedChanged");
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.link.newPosition) {
            this.transmittedSignal = compound.func_74762_e("Transmit");
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            LinkBehaviour prevlink = this.link;
            this.removeBehaviour(LinkBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.transmitter) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.REDSTONE_LINK.has(blockState)) {
            return;
        }
        if (this.getReceivedSignal() > 0 != (Boolean)blockState.func_177229_b((Property)BlockStateProperties.field_208194_u)) {
            this.receivedSignalChanged = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)blockState.func_235896_a_((Property)BlockStateProperties.field_208194_u));
        }
        if (this.receivedSignalChanged) {
            Direction attachedFace = ((Direction)blockState.func_177229_b((Property)RedstoneLinkBlock.field_176387_N)).func_176734_d();
            BlockPos attachedPos = this.field_174879_c.func_177972_a(attachedFace);
            this.field_145850_b.func_230547_a_(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            this.field_145850_b.func_230547_a_(attachedPos, this.field_145850_b.func_180495_p(attachedPos).func_177230_c());
        }
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)RedstoneLinkBlock.RECEIVER) == false;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }
}

