/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.content.logistics.block.redstone.ContentObserverTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.CapabilityItemHandler;

public class ContentObserverBlock
extends HorizontalBlock
implements ITE<ContentObserverTileEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public ContentObserverBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.CONTENT_OBSERVER.get((Direction)state.func_177229_b((Property)field_185512_D));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CONTENT_OBSERVER.create();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED, field_185512_D});
        super.func_206840_a(builder);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction preferredFacing = null;
        for (Direction face : Iterate.horizontalDirections) {
            BlockPos offsetPos = context.func_195995_a().func_177972_a(face);
            World world = context.func_195991_k();
            boolean canDetect = false;
            TileEntity tileEntity = world.func_175625_s(offsetPos);
            if (TileEntityBehaviour.get(tileEntity, TransportedItemStackHandlerBehaviour.TYPE) != null) {
                canDetect = true;
            } else if (tileEntity != null && tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                canDetect = true;
            } else if (tileEntity instanceof FunnelTileEntity) {
                canDetect = true;
            }
            if (!canDetect) continue;
            if (preferredFacing != null) {
                preferredFacing = null;
                break;
            }
            preferredFacing = face;
        }
        if (preferredFacing != null) {
            return (BlockState)state.func_206870_a((Property)field_185512_D, preferredFacing);
        }
        return (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_149744_f(BlockState state) {
        return (Boolean)state.func_177229_b((Property)POWERED);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_149744_f(blockState) && (side == null || side != ((Direction)blockState.func_177229_b((Property)field_185512_D)).func_176734_d()) ? 15 : 0;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        worldIn.func_195593_d(pos, (Block)this);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side != ((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            TileEntityBehaviour.destroy((IBlockReader)worldIn, pos, FilteringBehaviour.TYPE);
            worldIn.func_175713_t(pos);
        }
    }

    public void onFunnelTransfer(World world, BlockPos funnelPos, ItemStack transferred) {
        for (Direction direction : Iterate.horizontalDirections) {
            BlockPos detectorPos = funnelPos.func_177972_a(direction);
            BlockState detectorState = world.func_180495_p(detectorPos);
            if (!AllBlocks.CONTENT_OBSERVER.has(detectorState) || detectorState.func_177229_b((Property)field_185512_D) != direction.func_176734_d()) continue;
            this.withTileEntityDo((IBlockReader)world, detectorPos, te -> {
                FilteringBehaviour filteringBehaviour = TileEntityBehaviour.get(te, FilteringBehaviour.TYPE);
                if (filteringBehaviour == null) {
                    return;
                }
                if (!filteringBehaviour.test(transferred)) {
                    return;
                }
                te.activate(4);
            });
        }
    }

    @Override
    public Class<ContentObserverTileEntity> getTileEntityClass() {
        return ContentObserverTileEntity.class;
    }
}

