/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class HorizontalInteractionFunnelBlock
extends HorizontalBlock
implements IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty PUSHING = BooleanProperty.func_177716_a((String)"pushing");
    private BlockEntry<? extends FunnelBlock> parent;

    public HorizontalInteractionFunnelBlock(BlockEntry<? extends FunnelBlock> parent, AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.parent = parent;
        BlockState defaultState = (BlockState)this.func_176223_P().func_206870_a((Property)PUSHING, (Comparable)Boolean.valueOf(true));
        if (this.hasPoweredProperty()) {
            defaultState = (BlockState)defaultState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(defaultState);
    }

    public abstract boolean hasPoweredProperty();

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.FUNNEL.create();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        if (this.hasPoweredProperty()) {
            p_206840_1_.func_206894_a(new Property[]{POWERED});
        }
        super.func_206840_a(p_206840_1_.func_206894_a(new Property[]{field_185512_D, PUSHING}));
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState stateForPlacement = super.func_196258_a(ctx);
        if (this.hasPoweredProperty()) {
            stateForPlacement = (BlockState)stateForPlacement.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(ctx.func_195991_k().func_175640_z(ctx.func_195995_a())));
        }
        return stateForPlacement;
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (p_196243_1_.hasTileEntity() && (p_196243_1_.func_177230_c() != p_196243_4_.func_177230_c() && !FunnelBlock.isFunnel(p_196243_4_) || !p_196243_4_.hasTileEntity())) {
            p_196243_2_.func_175713_t(p_196243_3_);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.parent.asStack();
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbour, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        if (!this.canStillInteract(state, (IWorldReader)world, pos)) {
            BlockState parentState = this.parent.getDefaultState();
            if (state.func_235903_d_((Property)POWERED).orElse(false).booleanValue()) {
                parentState = (BlockState)parentState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)parentState.func_206870_a((Property)FunnelBlock.field_176387_N, state.func_177229_b((Property)field_185512_D));
        }
        return state;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return !world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d())).func_196954_c((IBlockReader)world, pos).func_197766_b();
    }

    protected abstract boolean canStillInteract(BlockState var1, IWorldReader var2, BlockPos var3);

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.hasPoweredProperty()) {
            return;
        }
        if (worldIn.field_72995_K) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((Property)POWERED);
        if (previouslyPowered != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
        }
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            context.func_195991_k().func_175656_a(context.func_195995_a(), (BlockState)state.func_235896_a_((Property)PUSHING));
        }
        return ActionResultType.SUCCESS;
    }
}

